---
name: project-uml-generator
description: Analyzes the project structure and code to generate UML diagrams, then creates a single HTML file named UML.html in the project root that embeds all diagrams and related documentation. Use when the user requests to generate UML diagrams or documentation for the project.
---
# Project UML Generator

## Instructions

When this Skill is activated, follow these steps to analyze the project and generate the UML documentation:

1. **Gather project files**: Use file listing tools to identify all relevant source code files in the project, focusing on code files while excluding non-essential files like dependencies or build artifacts.

2. **Analyze code structure**: Read and parse the contents of the identified files to extract key elements such as classes, interfaces, functions, relationships, and modules. Identify inheritance, composition, dependencies, and other structural relationships.

3. **Generate UML diagrams**: Based on the analysis, create textual representations of UML diagrams, including class diagrams, sequence diagrams, and component diagrams as appropriate for the project. Use a text-based diagram syntax that can be rendered in HTML.

4. **Create HTML structure**: Prepare a single HTML document that includes:
   - A title and overview section describing the project structure.
   - Sections for each type of UML diagram.
   - Embedded diagram renderings using a client-side library.
   - All necessary styles and scripts inlined within the HTML to ensure it is self-contained.

5. **Write the file**: Save the generated HTML content to a file named UML.html in the project root directory. Ensure no external dependencies are required for viewing the file.

## Best Practices

- Focus on high-level structures to avoid overwhelming details.
- Use clear labels and descriptions in the diagrams.
- Ensure the HTML is simple and accessible, with proper headings and sections for navigation.
- If the project is large, summarize key components rather than including everything.
- Always confirm with the user before writing the file if needed.

## Allowed Tools
Use only read-only and write tools as necessary, such as file reading, pattern matching, and file writing. Do not modify existing files or execute external commands.