---
name: code-bug-finder
description: Automated code bug-finding and report-generation assistant for multi-language repositories; designed to run in CI/CD on commits/PRs, produce human-readable bug reports with causes and fixes, and optionally create issues or fill PR templates in trackers like GitHub Issues or Jira.
---

Skill purpose

This Skill analyzes a codebase (multi-language: Python, Java, JavaScript/TypeScript, etc.), finds likely bugs and risky code patterns, and generates a structured report that explains root causes, reproductions, and recommended fixes. It is intended to run automatically in CI/CD on commits or pull requests and can optionally create issues or populate PR templates in issue trackers (GitHub Issues, Jira).

Step-by-step instructions Claude must follow

1. Input parsing
   - Accept inputs: repository URL or workspace path, target commit/PR identifier, target files or directories (optional), desired output format (markdown, JSON), language hints (optional), CI context (environment variables), and issue-tracker integration config (GitHub token, Jira API token, project keys).

2. Repository preparation
   - If given a URL, clone the repo at the given commit/PR. If given a path, use that workspace.
   - Determine languages and frameworks present by inspecting file extensions, key files (package.json, requirements.txt, pom.xml, build.gradle, etc.).

3. Static analysis and heuristics
   - Run lightweight, language-appropriate static checks and linters where available (e.g., eslint for JS/TS, flake8/pyflakes for Python, spotbugs or basic AST heuristics for Java). If executing linters is not possible, perform syntactic and semantic heuristics via AST parsing.
   - Check for common bug patterns: null/None misuse, off-by-one loops, resource leaks, unclosed connections, unchecked return values, exception swallowing, concurrency races (basic patterns), SQL injection/unsafe formatting, XSS/escape issues for web code, insecure crypto usage, use-after-free patterns in C/C++ (if present at surface level).
   - Run available unit tests (if allowed by CI config) to detect failing tests. Capture failing test details and stack traces.
   - For security-sensitive patterns, flag severity as security-high; for correctness and maintainability, use medium/low severities with examples.

4. Reproduce and localize
   - For each detected issue, attempt to localize the minimal file(s), function(s), and code lines involved. Provide code snippets and highlight suspicious lines.
   - If tests fail or errors reproduce, include reproduction steps (commands, inputs, expected vs actual behavior), stack traces, and exact commit/PR context.

5. Root cause analysis and suggested fixes
   - For each issue, explain the likely root cause in plain language (1–3 sentences). Provide 2–4 specific remediation suggestions: code changes with minimal patch snippets, alternative safer APIs, configuration changes, or test additions to prevent regressions.
   - Where applicable, provide small code diff examples or sample replacements. Use language-appropriate idioms and import statements.

6. Report assembly
   - Produce a structured report with sections: Summary, Affected files, Detailed findings (each with severity, location, explanation, reproduction steps, suggested fixes, example patch), Tests impacted, Confidence level, and Recommended next steps.
   - Provide output in both human-friendly Markdown and machine-friendly JSON when requested.

7. Issue tracker / PR integration (optional)
   - If integration is configured and permitted, create issues in the configured tracker for high/medium severity bugs. Each created issue should include: title, description (the finding), labels (severity, language, ci-automated), assignees (if provided), and a link to the CI run and commit/PR.
   - Optionally populate a PR comment or update a PR template with a short summary and link to the full report. Respect rate limits and consent flags.

8. CI/CD behavior and gating
   - In CI mode, summarize findings in build logs and optionally fail the build for critical security/high-severity issues if configured. Otherwise, mark status and attach the report artifact (Markdown/JSON) to the build artifacts.

9. Output delivery
   - Return the final report and metadata: counts by severity, created issue IDs (if any), and artifact links. If requested, return minimal actionable checklist for maintainers (top 3 highest-confidence fixes).

Usage examples

Example 1 — Run on a PR in CI (GitHub Actions)
- Inputs: repo workspace, PR number, GITHUB_TOKEN, run linters and tests.
- Expected output: a Markdown report uploaded as a build artifact, a PR comment summarizing top issues, and created GitHub Issues for critical findings.

Example 2 — Local scan for a Python package
- Inputs: local path, target files src/, tests/.
- Expected output: JSON report listing 5 findings (2 high, 2 medium, 1 low) with code snippets and suggested patches; unit test failures reproduced with stack traces.

Example 3 — Fill PR template
- Inputs: repo, PR, template path .github/PULL_REQUEST_TEMPLATE.md, top-3-fix summary flag.
- Expected output: Populate a PR template section with a concise summary of findings and a checklist of fixes.

Best practices

- Run linters and unit tests in an isolated environment or container in CI to avoid side effects. Limit runtime and sandbox test inputs to prevent long-running builds.
- Tune severity thresholds to reduce noisy low-value findings; allow teams to set ignore lists for third-party code or generated code directories.
- Always attach minimal reproductions and code snippets to make triage efficient.
- Avoid auto-applying fixes without human review; create issues/PRs instead and include suggested diff blocks.
- Respect access tokens and secrets: use short-lived tokens and do not log them in reports.

Related files and CI example scripts

- GitHub Actions workflow example to run this Skill automatically: .github/workflows/code-bug-finder.yml
- Example PR/issue templates with fields the Skill fills: templates/bug_report_template.md

Links (relative)
- .github/workflows/code-bug-finder.yml
- templates/bug_report_template.md
