---
name: ppt-auto-generator
description: Generates a lecture/teaching PowerPoint (PPTX) from plain-text or markdown outlines. Produces slide titles, bullet points, and speaker notes using a simple default template for quick output.
---

# PPT Auto Generator Skill

Purpose

This Skill converts a user-provided lecture note, outline, or markdown into a ready-to-download PowerPoint (PPTX) focused on educational/lecture use. It emphasizes clear content (titles, key bullets) and automatically generates speaker notes for each slide. A simple default visual template (colors, font sizes, slide layout) is applied for quick, consistent output.

Step-by-step instructions Claude must follow

1. Input interpretation
   - Accept plain text, structured outline, or markdown input from the user.
   - If input is ambiguous or very short, ask a concise clarifying question (e.g., "How many slides would you like?" or "Should I include speaker notes?").
   - Default assumptions if user does not respond: generate 8 slides, include speaker notes, use default template.

2. Parse content
   - If input is markdown, detect headings (`#`, `##`) and list items to map to slide titles and bullets.
   - If input is a plain outline, split into logical sections by blank lines or numbered headings.
   - Each top-level heading or clearly separated section becomes one slide title. Subitems become bullet points.
   - If there are more than 6 bullets for a slide, split into multiple slides preserving the slide title context.

3. Compose slide content
   - For each slide: create a concise title (derived from heading or a one-line summary). Limit to ~8–10 words.
   - Generate 3–6 bullet points per slide that capture core facts or teaching points, using short sentences or fragments.
   - Generate speaker notes: 2–4 short paragraphs or a few bullet speaking prompts per slide that expand on the bullets and suggest transitional phrasing.
   - If the user requests added items (examples, definitions, quiz questions), add up to one supplemental slide per requested item type.

4. Apply template and layout
   - Use a simple default template: single master slide layout with title area and body bullets. Fixed color palette and readable fonts.
   - Place speaker notes in the PPTX notes field for each slide.
   - Ensure readable font sizes: title 32–40pt, bullets 20–24pt.

5. File generation
   - Produce a valid PPTX file named from the provided title (fallback: "presentation.pptx").
   - Include slide order consistent with parsed outline.
   - If file creation is not possible within the environment, output a structured JSON or markdown representation of slides (title, bullets, speaker notes) and offer to export as PPTX when possible.

6. Output and follow-up
   - Provide the generated PPTX as a downloadable artifact or present the slide summary if direct file delivery is not supported.
   - Offer quick follow-ups: "Regenerate with more visuals", "Change template color", "Add quiz slide after slide 3".

Usage examples

- Example 1 (plain outline input):
  Input: "Week 1: Introduction to Photosynthesis\n- Light reactions\n- Calvin cycle\n- Importance to ecosystems"
  Behavior: Create one slide titled "Introduction to Photosynthesis" with bullets for Light reactions, Calvin cycle, Importance to ecosystems; generate speaker notes explaining each bullet.

- Example 2 (markdown input):
  Input: "# Neural Networks\n## What is a neuron?\n- Input, weights, activation\n## Training\n- Gradient descent\n- Loss functions"
  Behavior: Create slides: "Neural Networks" (overview), "What is a neuron?", "Training". Map second-level headings to slides and list items to bullets, generate speaker notes.

- Example 3 (short prompt):
  Input: "Create a 10-slide lecture about climate change basics with speaker notes"
  Behavior: Ask for any preferred focus or use default distribution: causes, impacts, mitigation, policy, summary. Generate 10 slides with bullets and notes.

Best practices

- Encourage users to provide structured outlines or markdown headings for best results.
- For long source texts, recommend providing section markers or asking for slide-per-section instructions.
- Keep bullets short and active; use speaker notes to expand rather than crowd slides with text.
- Offer template customization only as simple options (color scheme, font family) to keep generation fast.

Placeholders and defaults

- Default slide count: 8 if not specified.
- Default bullets per slide: 3–5.
- Default template: neutral educational palette (blue/gray), sans-serif font.
- Default filename: presentation.pptx (or derived from the first heading).

Related links and integrations

- If environment supports PPTX libraries (python-pptx or equivalent), implement generation using those libraries and map each slide/title/bullets/notes accordingly.

