'use strict';

// Minimal Express example demonstrating debug middleware
const express = require('express');
const { expressMiddleware, expressErrorHandler, bindProcessHandlers } = require('./debug-middleware');

bindProcessHandlers({});

const app = express();
app.use(express.json());
app.use(expressMiddleware({ logPath: process.env.DEBUG_LOG_PATH }));

app.get('/ok', (req, res) => {
  req.debugTrace('entered-handler', { sample: 1 });
  res.json({ hello: 'world' });
});

app.get('/boom', (req, res) => {
  req.debugTrace('before-error', { step: 'will throw' });
  throw new Error('intentional error for testing');
});

// error handler must come after routes
app.use(expressErrorHandler({}));

app.use(function (err, req, res, next) {
  res.status(500).json({ error: 'internal' });
});

app.listen(3000, () => console.log('Express app listening on 3000'));
