'use strict';

// Minimal Koa example demonstrating debug middleware
const Koa = require('koa');
const Router = require('@koa/router');
const { koaMiddleware, bindProcessHandlers } = require('./debug-middleware');

bindProcessHandlers({});

const app = new Koa();
const router = new Router();

app.use(koaMiddleware({ logPath: process.env.DEBUG_LOG_PATH }));

router.get('/ok', async (ctx) => {
  ctx.state.trace('entered-handler', { sample: 1 });
  ctx.body = { hello: 'world' };
});

router.get('/boom', async (ctx) => {
  ctx.state.trace('before-error', { step: 'will throw' });
  throw new Error('intentional error for testing');
});

app.use(router.routes()).use(router.allowedMethods());

app.on('error', (err, ctx) => {
  // Koa emits 'error' events; stack already logged by middleware
  console.error('app error', err);
});

app.listen(3001, () => console.log('Koa app listening on 3001'));
