---
name: flutter-app-metadata-generator
description: Generates App Store and Google Play metadata (title, short subtitle, and long description) for a Flutter app and compiles them into a metadata.md file. Produces market-specific versions respecting character limits and a single organized markdown output.
---

# Skill purpose

This Skill generates polished app metadata for a Flutter app targeted at both Apple App Store and Google Play. It produces market-specific versions of: app title, short subtitle/short description, and long description — written in an official, polite tone (clean, trustworthy, professional). The Skill outputs a ready-to-use metadata.md file structure containing both markets' entries and short guidance on suggested keywords.

# Step-by-step instructions (what Claude must do when this Skill is invoked)

1. Request required input from the user if not provided:
   - App name (product name or working name)
   - One-sentence summary of app purpose (core value)
   - 3–6 key features or benefits (short bullet list)
   - Target audience (who will use it)
   - Optional: important keywords or terms to emphasize
   - Confirm tone (default: official, polite)
2. Validate inputs and normalize text (trim, remove redundant punctuation).
3. Produce metadata for both markets following these character limits and fields:
   - Apple App Store (iOS):
     - App Name (max 30 characters)
     - Subtitle (max 30 characters)
     - Promotional Text (optional, up to 170 characters) — include if user requests or if it helps highlight feature
     - Description (up to 4000 characters)
   - Google Play Store (Android):
     - App Title (max 50 characters)
     - Short Description (max 80 characters)
     - Full Description (up to 4000 characters)
4. For each field, create a concise version that fits the character limit. If any generated text exceeds the limit, iteratively shorten while preserving meaning and keywords.
5. Ensure language is English and tone is official/polite. Avoid marketing hyperbole; emphasize trustworthiness and clarity.
6. Create a metadata.md document with the following structure:
   - Top: brief header describing the app and generation date
   - Section: Apple App Store metadata with each field labeled and the character count in parentheses
   - Section: Google Play metadata with each field labeled and the character count in parentheses
   - Section: Suggested keywords (comma-separated) and a short note on localization (advice to translate and adapt to target markets)
7. Provide at least one concrete example set (Apple + Google) based on the user input.
8. Deliver the text for metadata.md as plain markdown content and note that the user can copy it into a file named `metadata.md` in their project root.

# Output conventions and constraints

- Always produce both App Store and Google Play variants unless the user explicitly requests a single market.
- Respect the character limits precisely; include final character counts next to each field in metadata.md.
- Keep tone official and polite; do not use slang or emojis.
- If the user gives no keywords, extract 3–6 keywords from the features list.

# Usage examples

Example 1 — user input (minimal):
- App name: "SafeSchedule"
- One-sentence summary: "A secure calendar and task manager for professionals."
- Features: secure sync, privacy-first design, cross-platform notifications, calendar integrations
- Audience: busy professionals and small teams

When invoked, produce metadata.md containing:
- Apple App Store (Name, Subtitle, Promotional Text optional, Description)
- Google Play (Title, Short Description, Full Description)
- Suggested keywords and short localization note

Example 2 — user provides additional keywords: include them prioritized in the short title/subtitle and first lines of the description.

# Best practices

- Prioritize clarity in the first 1–2 sentences of long descriptions — these often show first to users.
- Put the app's core benefit and primary differentiator in the Apple subtitle and Google short description when possible.
- Keep titles concise; avoid punctuation-heavy or all-caps trademarks.
- Recommend localization: translate both short and long descriptions for target markets and adapt examples/references.

# Template for metadata.md (example layout produced by this Skill)

<!-- header -->
# metadata for: <App Name>
Generated: <YYYY-MM-DD>

## Apple App Store (iOS)
- App Name (max 30): <text> (chars: N)
- Subtitle (max 30): <text> (chars: N)
- Promotional Text (optional, max 170): <text> (chars: N)
- Description (max 4000):

<full description text>

## Google Play (Android)
- Title (max 50): <text> (chars: N)
- Short Description (max 80): <text> (chars: N)
- Full Description (max 4000):

<full description text>

## Suggested keywords
keyword1, keyword2, keyword3, ...

## Localization note
Translate descriptions and adapt examples/dates/formatting for each target market.

# Examples (generated sample using the Example 1 input above)

## Apple App Store (iOS)
- App Name (max 30): SafeSchedule (chars: 12)
- Subtitle (max 30): Secure calendar for professionals (chars: 33) -> trimmed to: Secure calendar for pros (chars: 24)
- Promotional Text (max 170): Keep your schedule private and synchronized across devices with enterprise-grade security. (chars: 92)
- Description (max 4000):
SafeSchedule is a secure calendar and task manager designed for busy professionals and small teams. With privacy-first syncing, calendar integrations, and reliable notifications, SafeSchedule helps you organize work and maintain control of your data. Key features:

• Privacy-first sync with end-to-end encryption
• Calendar integrations (Google, Outlook)
• Cross-device notifications and reminders
• Team sharing and role-based access

Start managing your time securely and increase productivity with a calendar built for professionals.

## Google Play (Android)
- Title (max 50): SafeSchedule — Secure Calendar (chars: 28)
- Short Description (max 80): A privacy-first calendar and task manager for professionals. (chars: 60)
- Full Description (max 4000):
SafeSchedule is a secure calendar and task manager built to help professionals organize work while keeping data private. Features include end-to-end encrypted sync, calendar imports, intelligent reminders, and team sharing controls. Configure integrations with Google Calendar and Outlook and manage roles for safe collaboration. Ideal for individuals and small teams who prioritize security and reliability.

## Suggested keywords
secure calendar, privacy-first, encrypted sync, professional planner, team scheduling

---

If you want, provide the app inputs now (app name, one-sentence summary, 3–6 features, target audience, optional keywords). I will generate the metadata.md content accordingly...


