---
name: python-code-review
description: Python 코드를 체계적으로 리뷰하여 버그, 설계 문제, 스타일 위반을 탐지하고 심각도별로 분류된 요약을 보고합니다
---
# 코드 리뷰 리포트

## 개요
- 파일명: example.py
- 리뷰 일시: 2026-01-11
- 전체 평가: Critical 1개, Major 2개, Minor 3개

## 발견된 이슈

### 🔴 Critical (즉시 수정 필요)
| 위치 | 이슈 | 설명 | 권장 수정 |
|------|------|------|----------|
| L15 | SQL 인젝션 | f-string으로 쿼리 생성 | 파라미터화된 쿼리 사용 |

### 🟠 Major (수정 권장)
| 위치 | 이슈 | 설명 | 권장 수정 |
|------|------|------|----------|
| L8 | 가변 기본 인자 | 리스트를 기본값으로 사용 | None으로 변경 후 내부에서 초기화 |

### 🟡 Minor (개선 제안)
| 위치 | 이슈 | 설명 | 권장 수정 |
|------|------|------|----------|
| L3 | 네이밍 컨벤션 | camelCase 사용 | snake_case로 변경 |

## 긍정적인 부분
- 타입 힌트 적극 활용
- 함수 단위 모듈화 우수

## 개선 제안 요약
1. 보안 취약점 즉시 수정 필요
2. 기본 인자 패턴 개선 권장
```

---

### 심각도 기준

| 심각도 | 기준 | 예시 |
|--------|------|------|
| 🔴 **Critical** | 런타임 오류, 보안 취약점, 데이터 손실 가능성 | SQL 인젝션, 예외 미처리로 인한 크래시 |
| 🟠 **Major** | 논리 오류, 성능 문제, 설계 결함 | 가변 기본 인자, SOLID 원칙 위반 |
| 🟡 **Minor** | 스타일 위반, 가독성 개선, 모범 사례 미준수 | PEP8 위반, 네이밍 불일치 |

---

### 스킬 구조
```
python-code-review/
├── SKILL.md                      # 메인 스킬 정의
└── references/
    ├── common-bugs.md            # Python 버그 패턴 12종
    └── design-patterns.md        # SOLID 원칙 및 설계 패턴 가이드
```

---

### 사용 예시

**입력:**
```
다음 코드를 리뷰해줘:

def get_users(ids, result=[]):
    for id in ids:
        query = f"SELECT * FROM users WHERE id = {id}"
        result.append(execute(query))
    return result