---
name: python-code-revisor
description: python-code-review 스킬의 리포트를 기반으로 Python 코드를 적극적으로 수정하는 스킬입니다. 버그 수정, 리팩토링, PEP8 스타일 수정, 성능 최적화를 종합적으로 수행합니다.
---
# Python Code Revisor Skill

## 개요

python-code-review 스킬의 리포트를 기반으로 Python 코드를 적극적으로 수정하는 스킬입니다. 버그 수정, 리팩토링, PEP8 스타일 수정, 성능 최적화를 종합적으로 수행합니다.

---

## 주요 기능

| 기능 | 설명 |
|------|------|
| **버그 수정** | 가변 기본 인자, 리소스 누수, 예외 처리 등 12가지 버그 패턴에 대한 표준 수정 적용 |
| **리팩토링** | 함수/클래스 추출, 조건문 단순화, 의존성 주입 등 9가지 리팩토링 패턴 적용 |
| **PEP8 스타일** | 네이밍, import 정리, 줄 길이, 공백 정규화 |
| **성능 최적화** | 리스트 컴프리헨션, 제너레이터, 캐싱, 자료구조 최적화 등 13가지 기법 적용 |

---

## 트리거 조건

다음과 같은 요청 시 스킬이 활성화됩니다:
- "코드 고쳐줘"
- "코드 수정해줘"
- "리뷰 결과대로 수정해줘"
- "버그 고쳐줘"
- "리팩토링해줘"
- "코드 개선해줘"

---

## 연계 스킬

| 스킬 | 역할 | 순서 |
|------|------|------|
| **python-code-review** | 코드 분석 및 이슈 탐지 | 1단계 |
| **python-code-revisor** | 이슈 기반 코드 수정 | 2단계 |

---

## 수정 범위

### 1. 버그 수정
- 가변 기본 인자 → None 패턴
- 리소스 누수 → context manager
- 예외 처리 → 구체적 예외 타입
- is vs == 혼동
- SQL 인젝션 → 파라미터화 쿼리
- 경계 조건 오류
- 늦은 바인딩 클로저
- 부동소수점 비교
- None 반환 처리
- 얕은 복사 문제
- 스레드 안전성
- 반복 중 컬렉션 수정

### 2. 리팩토링
- 함수 추출 (Extract Function)
- 클래스 추출 (Extract Class)
- 조기 반환 (Guard Clauses)
- 조건문을 다형성으로 (Strategy Pattern)
- 매직 넘버를 상수/Enum으로
- 임시 변수를 질의로
- 파라미터 객체화
- 의존성 주입 (Dependency Injection)
- 중복 코드 제거 (DRY)

### 3. PEP8 스타일
- 네이밍 컨벤션 (snake_case, PascalCase)
- import 순서 정리 (표준 라이브러리 → 서드파티 → 로컬)
- 줄 길이 조정 (79자)
- 공백 및 들여쓰기 정규화

### 4. 성능 최적화
- 리스트 컴프리헨션
- 제너레이터 (대용량 데이터)
- 적절한 자료구조 (set, dict, deque)
- 문자열 연결 최적화 (join, f-string)
- 캐싱 (lru_cache, cache)
- 지역 변수 활용
- 불필요한 연산 제거
- any/all 단축 평가
- itertools 활용
- 딕셔너리 최적화
- enumerate 사용
- 조건문 순서 최적화
- __slots__ (메모리 최적화)

---

## 출력 형식

```markdown
# 코드 수정 결과

## 수정 요약
- 총 {n}개 이슈 수정
- Critical: {n}개, Major: {n}개, Minor: {n}개

## 수정 내역

### 1. {이슈 제목} ({심각도})
**문제**: {원인 설명}
**해결**: {수정 방법}

수정 전:
```python
# 기존 코드
```

수정 후:
```python
# 수정된 코드
```

---

## 최종 수정 코드

```python
# 전체 수정된 코드
```

## 추가 권장 사항
- {추가 개선 제안}
```

---

## 수정 전략

| 항목 | 전략 |
|------|------|
| **수정 범위** | 발견된 모든 이슈 수정 |
| **우선순위** | Critical → Major → Minor |
| **접근 방식** | 적극적 (연관 개선 사항 포함) |
| **스타일** | 전체 코드 일관성 유지 |
| **추가 개선** | 타입 힌트, docstring 보완 |

---

## 스킬 구조

```
python-code-revisor/
├── SKILL.md                           # 메인 스킬 정의
└── references/
    ├── bug-fixes.md                   # 버그 수정 패턴 12종
    ├── refactoring-patterns.md        # 리팩토링 패턴 9종
    └── optimization.md                # 성능 최적화 기법 13종
```

---

## 사용 예시

**입력:**
```
다음 코드를 수정해줘:

def get_users(ids, result=[]):
    for id in ids:
        query = f"SELECT * FROM users WHERE id = {id}"
        result.append(execute(query))
    return result
```

**출력:**
- 가변 기본 인자 수정 (Major)
- SQL 인젝션 수정 (Critical)
- 타입 힌트 추가 (Minor)
- 최종 수정된 전체 코드

---

## 심각도 기준

| 심각도 | 기준 | 예시 |
|--------|------|------|
| 🔴 **Critical** | 런타임 오류, 보안 취약점, 데이터 손실 가능성 | SQL 인젝션, 예외 미처리로 인한 크래시 |
| 🟠 **Major** | 논리 오류, 성능 문제, 설계 결함 | 가변 기본 인자, SOLID 원칙 위반 |
| 🟡 **Minor** | 스타일 위반, 가독성 개선, 모범 사례 미준수 | PEP8 위반, 네이밍 불일치 |

---

## 대상 사용자

- Python 개발자
- 코드 품질 개선이 필요한 팀
- 레거시 코드 리팩토링 담당자
- Python 학습자

---

## 태그

`python` `code-revision` `bug-fix` `refactoring` `pep8` `optimization` `code-quality` `automated-fix`