// Async refactor sample: converting promises/callbacks to async/await with clearer error handling

// Before: uses promise chains
// api.fetchData().then(d => { return process(d); }).catch(err => { console.error(err); });

async function fetchAndProcess(api) {
  try {
    const data = await api.fetchData();
    return processData(data);
  } catch (err) {
    // Provide clear error context
    const error = new Error('fetchAndProcess failed: ' + (err && err.message));
    error.cause = err;
    throw error;
  }
}

function processData(data) {
  // keep processing pure and small
  if (!data) return null;
  return data.items ? data.items.length : 0;
}

module.exports = { fetchAndProcess, processData };
