// Module refactor sample: clearer exports and consistent naming

// Before: mixed export styles and unclear names
// module.exports = doThing; exports.helper = h;

function computeScore(user) {
  if (!user) return 0;
  return (user.stats?.wins || 0) * 10 - (user.stats?.losses || 0) * 2;
}

function formatUser(user) {
  return `${user.name} (${computeScore(user)})`;
}

// Export a consistent API object
module.exports = {
  computeScore,
  formatUser,
};
