// Simple refactor sample: clearer names and small helper extraction

// Before: function processes an array of items and returns the sum of valid values
// After: improved naming, extracted isValid helper

function process(items) {
  if (!Array.isArray(items)) return 0;
  let s = 0;
  for (let i = 0; i < items.length; i++) {
    const it = items[i];
    if (it != null && typeof it.value === 'number') {
      s += it.value;
    }
  }
  return s;
}

// Refactored version (example pattern):

function isValidValue(entry) {
  return entry != null && typeof entry.value === 'number';
}

function sumValues(entries) {
  if (!Array.isArray(entries)) return 0;
  let total = 0;
  for (const entry of entries) {
    if (isValidValue(entry)) total += entry.value;
  }
  return total;
}

module.exports = { sumValues, isValidValue };
