---
name: web-research-single-page-html-report
description: Investigate a user query via internet research and produce a polished, single-page HTML report (CSS embedded) in a clean newsletter style. Triggers: "create an HTML report", "research and summarize as one-page HTML", "one-page web research report", etc.
---

Skill purpose

This Skill performs short internet research on a user-provided topic and returns a single, self-contained HTML document (one page) that presents a clear, reader-friendly report. The HTML must include embedded CSS (no external resources), follow a clean newsletter style (large title, short subheadings, a highlighted summary box, readable body text, and no prominent buttons), and be aimed at a general audience. By default the report should be detailed enough to cover background, key evidence/arguments, and at least one illustrative example, while remaining constrained to one HTML page.

Step-by-step instructions Claude must follow

1. Confirm the user's topic and any preferences (language, tone, length limit, whether to include images). If the user did not specify language, default to the user's input language; if unclear, default to English.
2. Perform internet research to gather up-to-date factual information relevant to the query. Use available browsing tools/APIs. Collect supporting facts, background context, major viewpoints, and one concrete example or case study.
3. Do NOT include or display explicit source citations, URLs, or bibliographic lists in the returned HTML. Summarize findings into clean prose only. If policy or transparency requires, include a short note at the end of the document stating "Information gathered from web research" (no links or citations). If you are unable to browse, include a short banner near the top that says "Note: live web access unavailable; content based on knowledge cutoff and general sources."
4. Compose a single HTML document that meets these formatting constraints:
   - Include a top-level <html>, <head>, <meta charset="utf-8">, and <style> block with all CSS. No external CSS or JS files.
   - Use a clear newsletter layout: large title, subtitle or byline, a visually distinct summary box near the top, short subheadings dividing sections (Background, Key Points / Evidence, Example / Case Study, Implications / Takeaways), and a brief closing paragraph.
   - Keep content concise but detailed: roughly one printed page length when rendered at standard browser settings (aim for ~400–700 words depending on topic). Avoid overly long paragraphs; use short paragraphs and small headings.
   - Avoid interactive elements (no forms or prominent buttons). Minimal use of decorative imagery; if images are requested and allowed, embed via data URIs only if small; otherwise omit images.
   - Ensure accessible typography and contrast for general readers (readable font sizes, adequate line-height, clear color palette).
5. Use neutral, clear language suitable for a general audience. Explain technical terms briefly when they appear.
6. At the end of the HTML document, add a short one-line note (not a citation list) such as: "This report summarizes findings from web research." If browsers/tools indicate research was not performed, the note must reflect that (see step 3).
7. Return only the complete HTML document as the assistant response (no extra commentary or surrounding explanation). Ensure the response content is exactly the HTML document.

Usage examples

- User prompt: "Create a one-page HTML report summarizing the causes and recent trends in urban heat islands. Include background, main evidence, and one example city. Don't include sources." Expected behavior: Confirm language if needed, research, then return a single self-contained HTML file styled like a newsletter, including a summary box and sections Background, Evidence, Example: City X, Takeaways, and the single-line note about web research.

- User prompt: "Make a one-page HTML report explaining how electric vehicle batteries are recycled. Keep it simple for general readers, and embed CSS in the page." Expected behavior: Research recycling processes, summarize background, key processes, one example facility or step, and produce one-page HTML with embedded CSS and summary box.

Best practices

- If browsing is possible, prioritize authoritative, recent material when synthesizing facts, but remember to omit direct citations per user preference.
- Keep paragraphs short and use bolded small subheadings to improve scanability.
- Aim for clarity over exhaustive detail; include one concrete example to illustrate abstract points.
- If the user later requests sources, respond that sources were intentionally omitted per instructions and offer to provide a separate list if they change their preference.
- If the topic is highly specialized or requires verified citations (medical, legal, safety-critical), warn the user before generating a report and recommend consulting primary sources or professionals.

Examples of prompts the Skill should accept

- "Research X and produce a one-page HTML report with embedded CSS for general readers. No sources." 
- "Write a newsletter-style, single-page HTML summary about Y with background, evidence, and an example." 
- "Create a clean HTML page (CSS inside) explaining Z in detail for a general audience; keep it to one page."

Notes and fallback behavior

- If the system environment disallows web access, the Skill must still produce an HTML report but include an explicit short notice at the top: "Note: live web access unavailable; content based on internal knowledge." Do not fabricate claims presented as newly researched facts.
- Respect user requests about language and tone. By default, mirror the user's language; if ambiguous, default to English.

supporting_files: []
