---
name: feature-spec-generator
description: Generate a project feature specification list (feature names, descriptions, priority, recommended tech stack per feature, estimated difficulty, and dependencies) tailored for product managers and POs to use in roadmap planning and dev review.
allowed-tools: []
---

Skill purpose

This Skill generates a structured feature specification document from a short project prompt or set of user requirements. Output is formatted for product managers (PMs) and product owners (POs) to use in planning, prioritization, and handoff to engineering. Each feature entry includes a concise description, priority (High/Medium/Low), recommended technology choices, estimated implementation difficulty, and dependencies (other features, services, or infra).

Step-by-step instructions Claude must follow

1. Parse the user input to identify: project goals, target users, core functionality, constraints (timeline, budget, platforms), and any explicit tech preferences.
2. Generate a high-level scope summary (1–3 sentences) that captures the project intent and main user value.
3. Identify and list 6–12 candidate features (adjust count by project size: for very small projects 3–6, for medium 6–12, for large 12+). For each feature produce a feature block with the fields specified below.
4. For each feature block include these fields and follow the exact order:
   - Feature name: short, action-oriented title (3–6 words).
   - Description: 1–2 sentence user-focused description explaining what it does and why it matters.
   - Priority: assign High / Medium / Low. Base this on user value, risk, and dependencies. If user provided prioritization criteria, use them.
   - Recommended tech stack: list recommended frontend, backend, database, and any specific libraries/services (e.g., React, Next.js, Node/Express, Postgres, Redis, Firebase Auth, Stripe). If platform-specific (mobile/web), tailor choices.
   - Estimated difficulty: Very Low / Low / Medium / High / Very High with a 1–3 sentence rationale (consider integrations, third-party APIs, data modeling, security concerns).
   - Dependencies: list other features, platform components, or external services required prior to or alongside this feature.
   - Acceptance criteria (optional but recommended): 2–4 bullet points that define minimal shippable behavior for the feature.
5. After listing features, produce a short technology summary section that explains overall recommended stack choices and tradeoffs (1–3 short paragraphs), and note any cross-cutting concerns (auth, monitoring, CI/CD, compliance, performance).
6. Produce a simple initial prioritization roadmap: group features into three buckets (Now / Next / Later) derived from assigned priorities and dependency ordering. Keep it concise (bulleted lists).
7. If the user requested, generate export formats (Markdown and a compact JSON representation). Include the JSON representation inline after the Markdown section if requested.
8. Ask clarifying questions when the user input lacks key info: target platforms (web, iOS, Android), expected scale (users/requests), timeline, regulatory constraints, or existing systems.

Formatting rules

- Use clear headings for: High-level summary, Feature specifications, Tech summary, Roadmap (Now/Next/Later), and Optional JSON export.
- Keep each feature block compact (no more than ~8 lines). Use bullet lists inside feature blocks for readability.
- When recommending technologies, prefer widely used, well-supported options and justify any unusual choices.
- If the user gives explicit tech constraints, prioritize those and explain any tradeoffs.

Usage examples

Example 1 — Prompt:
"Build an MVP for a ride-sharing app for college campuses. Target: mobile apps (iOS/Android) and basic admin web. Timeline: 4 months. No existing backend."

Expected Skill output (abbreviated):
- High-level summary: A campus-focused ride-sharing MVP connecting riders and student drivers with real-time location and in-app payments.

Feature specifications:
- Feature name: User auth & profiles
  - Description: Email/SSO sign-up and profile management for riders and drivers.
  - Priority: High
  - Recommended tech stack: Mobile: React Native or Flutter; Backend: Node.js + Express; Auth: Firebase Auth or Auth0; DB: Postgres.
  - Estimated difficulty: Low — uses managed auth services.
  - Dependencies: None
  - Acceptance criteria: Email/SSO sign-up, profile edit, role selection

... (other features: Ride matching, Real-time location, Payments, Admin dashboard, Ratings)

Tech summary:
- Recommend React Native for cross-platform speed, Node/Postgres backend, Redis for short-term location caching, Stripe for payments.

Roadmap:
- Now: Auth & profiles, Ride request flow, Basic ride matching
- Next: Real-time tracking, Payments
- Later: Ratings, Promotions, Admin analytics

Example 2 — Prompt:
"Internal B2B dashboard to monitor IoT sensors. Priority: security and scalability. Existing backend: Kafka streaming and a microservices platform."

Best Practices

- Always ask clarifying questions if target platform, user scale, timeline, or constraints are missing.
- Prefer minimal viable feature sets for MVPs: focus on core user value and defer analytics or advanced features.
- When estimating difficulty, consider third-party integrations and data privacy/regulatory work as higher effort.
- Provide both a human-readable Markdown spec and machine-readable JSON if the user needs import into tooling.

When to ask clarifying questions

Ask if any of the following are missing:
- Target platforms (web/mobile/native)
- Expected scale or number of users
- Timeline constraints and delivery milestones
- Existing systems to integrate with (APIs, auth, databases)
- Preferred languages or frameworks

Output examples and automation tips

- Offer a compact JSON schema you can output on request, with keys: project_summary, features (array of feature objects), tech_summary, roadmap.
- Suggest integration: export JSON to project management tools or use the Markdown directly in planning docs.

supporting_files: []
