---
name: product-planner-agent
description: Creates developer-ready product planning artifacts from messy requirements: structured requirement lists, feature definitions with acceptance criteria, IA (page/screen structure), and developer handoff spec + checklist. Triggered by inputs such as raw requirement notes, meeting transcripts, or product briefs.
---

Skill purpose

This Skill transforms scattered product requirements into a complete, developer-friendly planning bundle. It is targeted at product managers and planners who need deliverables that developers can act on immediately, without ambiguity. Outputs include: a cleaned & prioritized requirement list, feature definitions with IDs and acceptance criteria, page/screen IA (textual), and a developer handoff document (spec + checklist + QA criteria).

Step-by-step instructions (what Claude must do)

1. Ingest input
   - Accept raw inputs: free-form notes, bullet lists, meeting transcripts, user stories, or a short brief.
   - If information is missing, list explicit clarifying questions (limit to the minimum needed to produce developer-ready artifacts). Do not pretend answers.

2. Normalize and structure requirements
   - Extract discrete requirement statements and map them into a flat list.
   - Remove duplicates and merge overlapping items; resolve obvious contradictions by noting chosen interpretation and why.
   - Identify ambiguous or vague phrases and either clarify with a short rewrite or mark them as questions for the requester.
   - Tag each requirement with priority: Must (M), Should (S), Could (C), Won't (W) (or map to required/optional as requested).
   - Break high-level requirements into smaller development-sized units when appropriate, accounting for engineering complexity.
   - Output: "Structured Requirement List" — each item with id, short title, original text, normalized text, priority, and notes on ambiguity or assumptions.

3. Define features (development unit)
   - For each development-sized requirement, create a Feature Definition entry with:
     - Feature ID (unique, short, e.g., F-001)
     - One-line summary
     - Detailed description (what it does, why)
     - Success/Acceptance Criteria (clear, testable, discrete points). Each criterion should be phrased so QA/dev can verify (Given/When/Then style or bullet pass/fail checks).
     - Edge cases & exception handling (explicitly list non-standard flows or inputs and desired behavior)
     - Dependencies (other features, APIs, external services)
     - Estimated complexity note (low/medium/high) and rationale (for planning; optional if not provided)
   - Do NOT include implementation code, frameworks, or step-by-step engineering solutions.
   - Output: "Feature Definition Document" containing all Feature entries.

4. Design page/screen IA (textual)
   - Produce a Page List with each page/screen having:
     - Page ID and name
     - Purpose/goal of the page
     - Primary features present on the page (by Feature ID)
     - Navigation: from which pages this page is reachable and where it links to (simple flow arrows like: Home -> Product List -> Product Detail -> Checkout)
     - UI elements categorized as Required vs Optional (for MVP vs enhancements)
   - Render a textual flow diagram (arrow-style) describing user navigation and major states.
   - Output: "Page Structure (Text IA)" with the above details.

5. Create developer handoff specification (core deliverable)
   - For each Feature ID, produce a developer-ready spec section that includes:
     - Feature ID & title
     - Context and user goal
     - Functional description (what must be implemented)
     - Acceptance criteria (same as in feature definitions) with explicit test steps where possible
     - Data requirements (inputs/outputs, important validations), API contract notes (if known) — keep to description level only
     - Error/edge-case handling
     - Performance/security constraints if applicable
     - Implementation constraints or non-goals (things explicitly out of scope)
     - QA checklist entries derived from acceptance criteria
     - Any open questions or decisions that require product/engineering alignment
   - Provide an overall development checklist that groups work by page or sprint-ready tasks, and a QA criteria summary for release gating.

6. Deliver artifacts in a clear bundle
   - Present a top-level index: Structured Requirements, Feature Definitions, Page IA, Developer Handoff (spec + checklist + QA criteria).
   - Use consistent IDs across all artifacts (Requirement IDs -> Feature IDs -> Page references).
   - Mark any unresolved questions or assumptions at the top of the bundle for immediate follow-up.

Usage examples

Example 1 — Input: short messy brief
- Raw input: "Users should be able to save favorite items, sync across devices, favorites show on profile. Also maybe add tags later."
- Claude should output: Structured Requirement List with entries for "save favorite" and "sync favorites", priority Must for save and sync, Could for tags. Feature definitions F-001 (Save Favorite) and F-002 (Sync Favorites) with acceptance criteria such as: "When user taps favorite, item appears in user's profile favorites list within 2 seconds"; edge cases like offline behavior; Page IA showing Favorites section on Profile page; Developer handoff with checklist and QA steps.

Example 2 — Input: meeting notes with questions
- Raw input includes: "Payment screen must be faster", "support promo codes maybe", and a question about whether guest checkout is allowed.
- Claude should: normalize into requirements, mark performance of payment screen as Must with measurable target if provided or request a target; write Feature Definition for payment optimization with performance acceptance criteria or ask for target; mark promo codes as Should/Could; list guest checkout as a clarifying question; include these in the developer handoff with explicit open questions section.

Best practices

- Keep acceptance criteria testable and atomic — each criterion should be verifiable with a pass/fail test.
- Prefer explicit numbers (timeouts, sizes, limits). If none given, ask for them rather than guessing.
- Maintain one canonical ID per feature and reference it everywhere (IA, requirements, handoff).
- Separate product decisions (what & why) from implementation constraints (how). The Skill must never prescribe implementation details.
- When unsure, output focused clarifying questions rather than assumptions; but where reasonable assumptions are made, list them clearly.

When to ask clarifying questions

- Missing measurable success criteria (e.g., "faster"), unclear scope (which user segments), or multiple conflicting requirements.
- If more than three major unknowns are detected, summarize them and request answers before creating the full developer handoff.

Outputs and formats

- Produce plain text/markdown style sections for: Structured Requirement List, Feature Definitions, Page Structure (Text IA), Developer Handoff Spec (per-feature), Development Checklist, and QA Criteria.
- Use consistent ID schemes: R-001.. for requirements, F-001.. for features, P-001.. for pages.

Examples of expected artifact headings

- Structured Requirement List
  - R-001: Save favorite (original text... normalized... priority... assumptions)

- Feature Definition
  - F-001 — Save Favorite
    - One-line summary
    - Description
    - Acceptance Criteria
    - Edge cases
    - Dependencies

- Page Structure (Text IA)
  - P-001 — Profile Page
    - Purpose
    - Features on page: F-001
    - Navigation: Home -> Profile
    - Required UI: Favorites section (list, remove button)

- Developer Handoff (per feature)
  - F-001 — Developer Spec
    - Context
    - Functional requirements
    - Acceptance tests (step-by-step)
    - QA checklist
    - Open questions

Best-practice phrasing samples

- Acceptance criterion example: "Given a logged-in user with at least one favorite, When they open Profile > Favorites, Then the favorite items are listed sorted by date added (newest first) and each item shows title, thumbnail, and remove action." 
- Edge case example: "If the user is offline and adds a favorite, the item should be queued locally and synced when the connection is restored; if conflict occurs, prefer server timestamped record and surface a transient notice." 

Related files / links

- None required. If the user attaches design mocks, API docs, or product briefs, the Skill should incorporate them and reference them by filename in the output.

Usage tips for the user

- Provide raw notes plus target priority (M/S/C) or accept the Skill's priority suggestions.
- Supply any non-functional targets (latency, throughput, retention) if you have them; otherwise expect clarifying questions.

