---
name: analyze-gap
description: 기능명세서와 소스코드를 체계적으로 비교 분석하여 누락된 기능, 불완전한 구현, 명세 불일치를 발견하고 개선점을 도출합니다. Next.js 프론트엔드와 Python 백엔드 환경에 특화된 100개 이상의 점검 항목을 제공하며, 단순 갭 분석을 넘어 사용자 가치를 높이는 신규 기능까지 적극적으로 발굴합니다.
---
# 기능 명세서 vs 소스코드 갭 분석 및 개선점 발굴

## 분석 목표
기능명세서와 실제 구현된 소스코드를 체계적으로 비교하여 누락, 불일치, 개선 기회를 발굴하고, **사용자 가치를 높이는 신규 기능을 적극적으로 제안**한다.

---

## 신규 기능 발굴의 중요성

### 왜 신규 기능 발굴이 필요한가?

**1. 명세서의 한계**
- 명세서는 작성 시점의 요구사항만 반영
- 실제 구현 과정에서 새로운 인사이트 발견
- 사용자 피드백과 시장 변화 반영 필요
- 기술 발전으로 이전에 불가능했던 기능 구현 가능

**2. 경쟁력 확보**
- 단순히 명세서 구현만으로는 차별화 어려움
- 사용자 기대를 뛰어넘는 경험 제공 필요
- 시장 선점을 위한 선제적 기능 개발

**3. 기술 부채 예방**
- 초기 설계 시 고려하지 못한 확장성 확보
- 향후 요구사항 변화에 유연하게 대응
- 리팩토링 비용 절감

### 신규 기능 발굴 시 고려 원칙
```
┌─────────────────────────────────────────────────────────┐
│  신규 기능 평가 매트릭스                                   │
├─────────────────────────────────────────────────────────┤
│                                                         │
│         높음 │  Quick Win  │  Strategic   │            │
│   사용자     │  (즉시 개발) │  (로드맵 포함) │            │
│   가치      ├─────────────┼──────────────┤            │
│         낮음 │   Skip     │  Reconsider  │            │
│              │  (보류)     │  (재검토)     │            │
│              └─────────────┴──────────────┘            │
│                  낮음          높음                     │
│                     구현 복잡도                         │
└─────────────────────────────────────────────────────────┘
```

---

## 1단계: 입력 자료 확인

### 기능명세서 점검
- [ ] 문서 버전 및 최종 수정일 확인
- [ ] 기능 목록이 명확하게 정의되어 있는가
- [ ] 각 기능의 수락 기준(Acceptance Criteria)이 있는가
- [ ] 비기능 요구사항(성능, 보안, 접근성)이 명시되어 있는가
- [ ] 예외 상황 및 엣지 케이스가 정의되어 있는가
- [ ] API 명세(엔드포인트, 요청/응답 스키마)가 문서화되어 있는가
- [ ] **명세서에서 "향후 고려" 또는 "Phase 2"로 미뤄진 기능 목록 확인**
- [ ] **경쟁 제품 대비 누락된 기능 파악**

### 소스코드 점검

**프론트엔드 (Next.js)**
- [ ] Next.js 버전 확인 (App Router vs Pages Router)
- [ ] 프로젝트 구조 파악 (`/app`, `/pages`, `/components`, `/lib`)
- [ ] 라우팅 구조 확인 (동적 라우트, 병렬 라우트, 인터셉트 라우트)
- [ ] 서버/클라이언트 컴포넌트 구분 확인
- [ ] 상태 관리 라이브러리 확인 (Zustand, Redux, Jotai 등)
- [ ] API 호출 방식 확인 (Server Actions, Route Handlers, 외부 API)
- [ ] 스타일링 방식 확인 (Tailwind, CSS Modules, styled-components)
- [ ] 테스트 설정 확인 (Jest, React Testing Library, Playwright)
- [ ] **현재 구현된 UI 패턴에서 확장 가능한 영역 식별**

**백엔드 (Python)**
- [ ] 프레임워크 확인 (FastAPI, Django, Flask)
- [ ] Python 버전 및 의존성 관리 (requirements.txt, pyproject.toml, Poetry)
- [ ] 프로젝트 구조 파악 (`/routers`, `/services`, `/models`, `/schemas`)
- [ ] ORM 확인 (SQLAlchemy, Django ORM, Tortoise)
- [ ] 데이터베이스 종류 (PostgreSQL, MySQL, MongoDB)
- [ ] 인증 방식 확인 (JWT, OAuth2, Session)
- [ ] API 문서화 확인 (OpenAPI/Swagger, ReDoc)
- [ ] 테스트 설정 확인 (pytest, unittest)
- [ ] **데이터 모델에서 활용되지 않는 필드/관계 확인**
- [ ] **기존 API 확장 가능성 검토**

---

## 2단계: 기능별 상세 매핑

### 매핑 테이블 작성

| ID | 명세서 기능 | 프론트엔드 구현 | 백엔드 구현 | 상태 | 비고 |
|----|------------|----------------|-------------|------|------|
| F001 | 사용자 로그인 | app/login/page.tsx | /auth/login | ✅ 완료 | |
| F002 | 비밀번호 재설정 | - | - | ❌ 미구현 | 우선 개발 필요 |
| F003 | 데이터 필터링 | components/Filter.tsx | /items?filter= | ⚠️ 부분 | 날짜 필터 누락 |
| **NEW** | **소셜 로그인** | - | - | 💡 **신규 제안** | 사용자 편의성 향상 |

### 상태 정의
- ✅ **완료**: 명세서 요구사항 100% 충족
- ⚠️ **부분 구현**: 핵심 기능은 있으나 일부 누락
- 🔄 **구현 중**: 작업 진행 중
- ❌ **미구현**: 코드에 존재하지 않음
- ⚡ **명세 초과**: 명세서에 없는 추가 구현
- 💡 **신규 제안**: 명세서에 없으나 추가 권장

---

## 3단계: 심층 분석 체크리스트

### A. 기능 완전성 검증

**입력 처리**
- [ ] 모든 필수 입력 필드가 구현되었는가
- [ ] 입력 유효성 검사가 명세서와 일치하는가 (프론트 + 백엔드 이중 검증)
- [ ] 입력값 범위/형식 제한이 적용되었는가
- [ ] 필수/선택 필드 구분이 올바른가

**출력 및 표시**
- [ ] 명세서에 정의된 모든 출력이 표시되는가
- [ ] 데이터 포맷(날짜, 숫자, 통화)이 명세와 일치하는가
- [ ] 빈 상태(Empty State) 처리가 되어 있는가
- [ ] 페이지네이션/무한스크롤이 명세대로 동작하는가

**비즈니스 로직**
- [ ] 계산 로직이 명세서 공식과 일치하는가
- [ ] 상태 전이(State Transition)가 올바른가
- [ ] 권한/역할별 접근 제어가 구현되었는가
- [ ] 비즈니스 규칙 예외 처리가 되어 있는가

---

### B. Next.js 프론트엔드 전용 점검

**App Router 구조 (Next.js 13+)**
- [ ] `layout.tsx` 적절히 활용 (공통 레이아웃, 메타데이터)
- [ ] `loading.tsx` 로딩 UI 구현
- [ ] `error.tsx` 에러 바운더리 구현
- [ ] `not-found.tsx` 404 페이지 구현
- [ ] `route.ts` API 라우트 핸들러 적절히 사용
- [ ] 동적 라우트 `[slug]`, `[...catchAll]` 올바르게 구현
- [ ] 라우트 그룹 `(group)` 활용하여 구조화

**서버/클라이언트 컴포넌트**
- [ ] `'use client'` 지시어 필요한 곳에만 사용
- [ ] 서버 컴포넌트에서 데이터 페칭 최대 활용
- [ ] 클라이언트 컴포넌트 최소화 (인터랙션 필요한 부분만)
- [ ] 서버 컴포넌트에서 민감한 정보 노출 방지
- [ ] Hydration 에러 없는지 확인

**데이터 페칭 및 캐싱**
- [ ] `fetch` 캐싱 전략 적절히 설정 (`cache`, `revalidate`)
- [ ] Server Actions 활용 (폼 제출, 데이터 변경)
- [ ] `revalidatePath`, `revalidateTag` 적절히 사용
- [ ] Parallel Data Fetching 활용 (Promise.all)
- [ ] Streaming/Suspense 활용하여 UX 개선

**상태 관리**
- [ ] URL 상태 활용 (`useSearchParams`, `usePathname`)
- [ ] 서버 상태 vs 클라이언트 상태 구분
- [ ] 전역 상태 최소화
- [ ] React Query/SWR 캐싱 전략 적절한가

**렌더링 최적화**
- [ ] 정적 생성(SSG) 가능한 페이지 식별 (`generateStaticParams`)
- [ ] ISR(Incremental Static Regeneration) 활용
- [ ] 동적 렌더링 필요한 페이지만 동적으로
- [ ] `dynamic = 'force-dynamic'` 남용하지 않는가

**이미지 및 폰트**
- [ ] `next/image` 사용하여 이미지 최적화
- [ ] 적절한 `sizes`, `priority` 속성 설정
- [ ] `next/font` 사용하여 폰트 최적화
- [ ] 외부 이미지 도메인 `next.config.js`에 등록

**메타데이터 및 SEO**
- [ ] `metadata` 객체 또는 `generateMetadata` 함수 사용
- [ ] Open Graph, Twitter Card 메타태그 설정
- [ ] `robots.txt`, `sitemap.xml` 생성
- [ ] 구조화된 데이터 (JSON-LD) 적용

**인증 및 미들웨어**
- [ ] `middleware.ts` 적절히 활용 (인증, 리다이렉트, 로깅)
- [ ] 보호된 라우트 접근 제어
- [ ] NextAuth.js / Auth.js 설정 올바른가
- [ ] 세션 관리 전략 적절한가

**환경 변수**
- [ ] `NEXT_PUBLIC_` 접두사 클라이언트 변수에만 사용
- [ ] 민감한 키 서버에서만 접근
- [ ] 환경별 설정 분리 (development, production)

---

### C. Python 백엔드 전용 점검

**FastAPI 구조**
- [ ] 라우터 모듈화 (`APIRouter` 활용)
- [ ] 의존성 주입 (`Depends`) 적절히 사용
- [ ] Pydantic 모델로 요청/응답 스키마 정의
- [ ] 비동기 함수 (`async def`) 적절히 활용
- [ ] 백그라운드 태스크 (`BackgroundTasks`) 활용

**Django 구조 (사용 시)**
- [ ] 앱 모듈화 적절한가
- [ ] Class-Based View vs Function-Based View 일관성
- [ ] Django REST Framework Serializer 활용
- [ ] 쿼리셋 최적화 (`select_related`, `prefetch_related`)

**API 설계**
- [ ] RESTful 규칙 준수 (HTTP 메서드, 상태 코드)
- [ ] 엔드포인트 네이밍 일관성 (`/users/{id}` vs `/user/{id}`)
- [ ] 버저닝 전략 (`/api/v1/`)
- [ ] 페이지네이션 구현 (offset, cursor 기반)
- [ ] 필터링, 정렬, 검색 파라미터 표준화

**Pydantic 스키마 (FastAPI)**
- [ ] 요청 스키마와 응답 스키마 분리
- [ ] `Optional`, `Field` 적절히 사용
- [ ] 커스텀 Validator 구현
- [ ] 스키마 상속으로 중복 제거
- [ ] `Config` 설정 (orm_mode, extra 등)

**데이터베이스 및 ORM**
- [ ] 마이그레이션 파일 최신 상태 (Alembic, Django migrations)
- [ ] 인덱스 적절히 설정
- [ ] N+1 쿼리 문제 없는가
- [ ] 트랜잭션 처리 적절한가
- [ ] Connection Pool 설정
- [ ] Soft Delete 구현 여부

**비동기 처리**
- [ ] I/O 바운드 작업 비동기 처리
- [ ] CPU 바운드 작업 별도 워커 (Celery, RQ)
- [ ] 비동기 DB 드라이버 사용 (asyncpg, databases)
- [ ] 동시성 제어 (Lock, Semaphore)

**인증 및 권한**
- [ ] JWT 토큰 검증 로직
- [ ] 토큰 만료 및 갱신 처리
- [ ] 역할 기반 접근 제어 (RBAC)
- [ ] API Key 인증 (필요시)
- [ ] OAuth2 스코프 활용

**에러 처리**
- [ ] 커스텀 예외 클래스 정의
- [ ] 전역 예외 핸들러 (`@app.exception_handler`)
- [ ] 일관된 에러 응답 포맷
- [ ] 상세한 에러 메시지 (개발) vs 안전한 메시지 (운영)

**로깅 및 모니터링**
- [ ] 구조화된 로깅 (JSON 포맷)
- [ ] 로그 레벨 적절히 설정
- [ ] 요청/응답 로깅 미들웨어
- [ ] 성능 메트릭 수집 (Prometheus, OpenTelemetry)

**테스트**
- [ ] pytest 픽스처 활용
- [ ] 테스트 DB 분리 (SQLite in-memory, TestContainer)
- [ ] API 엔드포인트 테스트 (`TestClient`, `httpx`)
- [ ] 모킹 적절히 사용 (`unittest.mock`, `pytest-mock`)
- [ ] 테스트 커버리지 측정

**환경 설정**
- [ ] Pydantic Settings로 환경 변수 관리
- [ ] `.env` 파일 gitignore 처리
- [ ] 환경별 설정 분리
- [ ] Secret 관리 (AWS Secrets Manager, HashiCorp Vault)

---

### D. 프론트엔드-백엔드 통합 점검

**API 계약**
- [ ] OpenAPI 스펙 프론트엔드와 동기화
- [ ] TypeScript 타입 자동 생성 활용 (openapi-typescript)
- [ ] 요청/응답 스키마 불일치 없는가
- [ ] API 버전 호환성 유지

**인증 플로우**
- [ ] 로그인/로그아웃 플로우 완전한가
- [ ] 토큰 저장 방식 (httpOnly Cookie vs localStorage)
- [ ] 토큰 갱신 로직 구현
- [ ] 인증 실패 시 리다이렉트 처리

**에러 처리 통합**
- [ ] 백엔드 에러 응답 프론트엔드에서 적절히 처리
- [ ] 네트워크 에러 처리
- [ ] 타임아웃 처리
- [ ] 재시도 로직 (Exponential Backoff)

**데이터 흐름**
- [ ] 낙관적 업데이트(Optimistic Update) 구현
- [ ] 실시간 데이터 동기화 (WebSocket, SSE, Polling)
- [ ] 캐시 무효화 전략 일관성

**CORS 설정**
- [ ] 허용 오리진 적절히 설정
- [ ] 필요한 헤더만 허용
- [ ] Credentials 설정 올바른가

---

### E. 엣지 케이스 및 예외 처리

**데이터 경계값**
- [ ] 빈 값(null, undefined, None, 빈 문자열) 처리
- [ ] 최소/최대값 경계 처리
- [ ] 특수 문자 입력 처리
- [ ] 대용량 데이터 처리 (1000건 이상)
- [ ] 중복 데이터 처리
- [ ] Unicode/이모지 처리

**사용자 행동**
- [ ] 중복 클릭/제출 방지 (프론트 + 백엔드)
- [ ] 뒤로가기 버튼 처리
- [ ] 브라우저 새로고침 시 상태 유지
- [ ] 다중 탭/창에서의 동작
- [ ] 세션 만료 처리
- [ ] 동시 편집 충돌 처리

**네트워크/시스템**
- [ ] API 실패 시 에러 메시지 표시
- [ ] 네트워크 지연 시 로딩 상태 표시
- [ ] 오프라인 상태 처리
- [ ] Rate Limiting 대응
- [ ] 서버 다운 시 Graceful Degradation

---

### F. 비기능 요구사항 점검

**성능 (프론트엔드)**
- [ ] Core Web Vitals 측정 (LCP, FID, CLS)
- [ ] 번들 사이즈 분석 (`@next/bundle-analyzer`)
- [ ] 코드 스플리팅 적용 (`dynamic import`)
- [ ] 이미지 Lazy Loading
- [ ] 불필요한 리렌더링 방지 (`memo`, `useMemo`, `useCallback`)

**성능 (백엔드)**
- [ ] API 응답 시간 측정 (P50, P95, P99)
- [ ] 데이터베이스 쿼리 최적화
- [ ] 캐싱 적용 (Redis, In-memory)
- [ ] Connection Pooling
- [ ] 비동기 처리로 블로킹 방지

**보안**
- [ ] XSS 방지 (입력값 이스케이프, CSP 헤더)
- [ ] CSRF 보호 (토큰 또는 SameSite Cookie)
- [ ] SQL Injection 방지 (ORM 파라미터 바인딩)
- [ ] 민감 정보 노출 방지 (로그, 응답, 콘솔)
- [ ] HTTPS 강제
- [ ] 보안 헤더 설정 (Helmet.js, SecurityMiddleware)
- [ ] Rate Limiting 구현
- [ ] 입력값 Sanitization

**접근성 (A11y)**
- [ ] 키보드 네비게이션 지원
- [ ] 스크린 리더 호환 (ARIA 레이블)
- [ ] 색상 대비 충분한가 (WCAG AA)
- [ ] 폼 레이블 연결
- [ ] 포커스 관리

**호환성**
- [ ] 주요 브라우저 테스트 (Chrome, Safari, Firefox, Edge)
- [ ] 모바일 반응형 지원
- [ ] 다국어/국제화 지원 (next-intl, i18next)
- [ ] 타임존 처리

---

### G. 코드 품질 점검

**프론트엔드**
- [ ] ESLint 규칙 준수
- [ ] TypeScript strict 모드 활성화
- [ ] 컴포넌트 Props 타입 정의
- [ ] 커스텀 훅 분리
- [ ] 관심사 분리 (UI / 로직 / 데이터)

**백엔드**
- [ ] 타입 힌트 100% 적용
- [ ] Ruff/Black/isort 포맷팅
- [ ] MyPy 타입 체크 통과
- [ ] Docstring 작성
- [ ] 단일 책임 원칙 준수

**공통**
- [ ] 중복 코드 제거 (DRY)
- [ ] 매직 넘버/문자열 상수화
- [ ] 불필요한 주석 및 console.log/print 제거
- [ ] TODO/FIXME 정리
- [ ] 일관된 네이밍 컨벤션

---

## 4단계: 신규 기능 발굴 (⭐ 핵심 섹션)

### 신규 기능 발굴 프로세스
```
┌────────────────┐     ┌────────────────┐     ┌────────────────┐
│  현황 분석     │ ──▶ │  기회 탐색     │ ──▶ │  가치 평가     │
│  - 코드 리뷰   │     │  - 패턴 발견   │     │  - ROI 분석    │
│  - 사용자 흐름 │     │  - 경쟁사 분석 │     │  - 우선순위화  │
└────────────────┘     └────────────────┘     └────────────────┘
```

### A. 프론트엔드 (Next.js) 신규 기능 발굴

**사용자 경험 혁신**
- [ ] 현재 사용자 흐름에서 3클릭 이상 필요한 작업 식별 → 단축 기능 제안
- [ ] 반복 입력 패턴 분석 → 자동완성/템플릿 기능 제안
- [ ] 사용자가 자주 이탈하는 페이지 식별 → 개선 또는 간소화
- [ ] 모바일 사용자 경험 분석 → 터치 최적화 기능 제안

**기능 확장 기회**
| 현재 상태 | 발굴 가능한 신규 기능 | 기대 효과 |
|----------|---------------------|----------|
| 단일 항목 수정 | 일괄 편집 (Bulk Edit) | 작업 시간 80% 단축 |
| 기본 검색 | 고급 필터 + 저장된 검색 | 재사용성 향상 |
| 수동 새로고침 | 실시간 업데이트 (WebSocket/SSE) | 즉시성 확보 |
| 데이터 조회만 | 내보내기 (CSV/Excel/PDF) | 외부 활용 가능 |
| 개인 사용 | 공유/협업 기능 | 팀 생산성 향상 |
| 단일 뷰 | 대시보드/요약 뷰 | 인사이트 제공 |

**Next.js 기술 기반 신규 기능**
- [ ] **Parallel Routes** 활용 → 모달/사이드패널 동시 표시
- [ ] **Intercepting Routes** 활용 → 상세 페이지 미리보기
- [ ] **Server Actions** 활용 → 폼 제출 없이 즉시 반영
- [ ] **Streaming** 활용 → 대용량 데이터 점진적 로딩
- [ ] **Partial Prerendering** 활용 → 정적/동적 콘텐츠 혼합 최적화
- [ ] **Route Handlers** 활용 → BFF(Backend for Frontend) 패턴 구현

**UI/UX 트렌드 기반 제안**
- [ ] 커맨드 팔레트 (⌘+K) → 파워 유저 생산성 향상
- [ ] 다크 모드 / 테마 커스터마이징 → 사용자 선호 반영
- [ ] 키보드 단축키 시스템 → 접근성 및 효율성
- [ ] 드래그 앤 드롭 인터랙션 → 직관적 조작
- [ ] 온보딩 투어 / 가이드 → 신규 사용자 적응 지원
- [ ] 알림 센터 → 중요 정보 놓침 방지

**프론트엔드 신규 기능 체크리스트**
- [ ] 현재 구현된 각 페이지에서 "이 페이지에서 더 할 수 있는 일"은 무엇인가?
- [ ] 사용자가 "있으면 좋겠다"고 요청할 만한 기능은?
- [ ] 경쟁 제품에는 있지만 우리 제품에 없는 기능은?
- [ ] 최신 Next.js 기능 중 활용하지 않는 것은?
- [ ] 현재 외부 도구로 하는 작업을 내재화할 수 있는가?

---

### B. 백엔드 (Python) 신규 기능 발굴

**API 확장 기회**
| 현재 상태 | 발굴 가능한 신규 기능 | 기대 효과 |
|----------|---------------------|----------|
| 개별 API 호출 | Batch/Bulk API | 네트워크 왕복 감소 |
| 동기 처리만 | 비동기 작업 + 상태 조회 | 긴 작업 UX 개선 |
| 기본 CRUD | GraphQL 또는 유연한 필드 선택 | 오버페칭 방지 |
| 단순 조회 | 집계/통계 API | 분석 기능 지원 |
| 현재 데이터만 | 이력/감사 로그 API | 추적성 확보 |
| 단일 인증 | 다중 인증 (MFA, SSO) | 보안 강화 |

**데이터 모델 확장 기회**
- [ ] 기존 테이블에 추가 가능한 유용한 필드 (태그, 메모, 우선순위 등)
- [ ] 새로운 엔티티 간 관계 설정 가능성
- [ ] 소프트 삭제 → 휴지통/복원 기능
- [ ] 버전 관리 → 변경 이력 추적
- [ ] 다중 테넌시 지원 필요성

**Python/FastAPI 기술 기반 신규 기능**
- [ ] **WebSocket 엔드포인트** → 실시간 알림/채팅
- [ ] **Server-Sent Events** → 단방향 실시간 업데이트
- [ ] **Background Tasks** → 이메일 발송, 파일 처리
- [ ] **Celery/RQ 통합** → 대용량 비동기 작업
- [ ] **Redis 캐싱** → 자주 조회되는 데이터 성능 향상
- [ ] **Rate Limiting 고도화** → 사용자/플랜별 제한

**데이터 활용 신규 기능**
- [ ] **검색 고도화** → Elasticsearch/Typesense 통합
- [ ] **추천 시스템** → 사용자 행동 기반 추천
- [ ] **분석/리포팅** → 집계 데이터 시각화 지원
- [ ] **AI/ML 통합** → 자동 분류, 예측, 요약
- [ ] **데이터 파이프라인** → ETL/정기 배치 처리

**백엔드 신규 기능 체크리스트**
- [ ] 현재 API로 불가능하지만 프론트엔드에서 필요한 기능은?
- [ ] 데이터베이스에 쌓이는 데이터로 추가 가치를 만들 수 있는가?
- [ ] 외부 서비스 연동으로 기능 확장 가능한가? (결제, 알림, 저장소 등)
- [ ] 관리자/운영자를 위한 기능이 충분한가?
- [ ] API 성능 병목 지점을 해결할 새로운 접근법은?

---

### C. 통합 관점 신규 기능 발굴

**End-to-End 사용자 시나리오 분석**
```
사용자 여정 맵핑:
1. [가입] → 2. [온보딩] → 3. [핵심 기능 사용] → 4. [반복 사용] → 5. [확장/공유]

각 단계에서:
- 현재 지원하는 기능은?
- 사용자가 겪는 불편함은?
- 이탈을 방지할 수 있는 기능은?
- 다음 단계로 유도할 수 있는 기능은?
```

**크로스 플랫폼 기능 기회**
- [ ] 모바일 앱 (React Native / Flutter) 필요성
- [ ] PWA(Progressive Web App) 전환
- [ ] 브라우저 확장 프로그램
- [ ] 데스크톱 앱 (Electron / Tauri)
- [ ] API 공개 (Third-party 연동)
- [ ] Webhook 지원 (이벤트 알림)

**자동화 및 워크플로우**
- [ ] 반복 작업 자동화 (스케줄링, 트리거)
- [ ] 조건부 알림 (특정 이벤트 발생 시)
- [ ] 외부 서비스 연동 (Slack, Email, SMS)
- [ ] 워크플로우 빌더 (노코드/로우코드)

---

### D. 신규 기능 평가 템플릿

각 발굴된 신규 기능에 대해 평가:
```markdown
## 신규 기능 제안: [기능명]

### 개요
- **설명**: 
- **대상 사용자**: 
- **해결하는 문제**: 

### 가치 평가
| 항목 | 점수 (1-5) | 비고 |
|------|-----------|------|
| 사용자 가치 | | |
| 비즈니스 가치 | | |
| 기술적 실현 가능성 | | |
| 기존 코드 재사용성 | | |
| **총점** | /20 | |

### 구현 범위
- **프론트엔드**: 
- **백엔드**: 
- **예상 공수**: 

### 의존성 및 리스크
- 

### 권장 우선순위
- [ ] 🔴 즉시 개발 (MVP 포함)
- [ ] 🟠 다음 스프린트
- [ ] 🟡 로드맵 포함
- [ ] 🟢 백로그 등록
```

---

## 5단계: 결과 정리

### 요약 대시보드
```
총 기능 수: __ 개
├── ✅ 완료: __ 개 (__%)
├── ⚠️ 부분 구현: __ 개 (__%)
├── ❌ 미구현: __ 개 (__%)
├── ⚡ 명세 초과: __ 개
└── 💡 신규 제안: __ 개  ⭐

프론트엔드 이슈: __ 건
백엔드 이슈: __ 건
통합 이슈: __ 건

우선순위별 분류:
├── 🔴 Critical: __ 건
├── 🟠 High: __ 건
├── 🟡 Medium: __ 건
└── 🟢 Low: __ 건

💡 신규 기능 제안:
├── Quick Win (즉시 개발 가능): __ 건
├── Strategic (로드맵 포함): __ 건
└── Future (향후 검토): __ 건
```

### 우선순위별 액션 아이템

**🔴 Critical (즉시 해결)**
| 영역 | 항목 | 설명 | 담당 | 예상 공수 |
|------|------|------|------|----------|
| FE/BE | | | | |

**🟠 High (이번 스프린트)**
| 영역 | 항목 | 설명 | 담당 | 예상 공수 |
|------|------|------|------|----------|
| FE/BE | | | | |

**🟡 Medium (다음 스프린트)**
| 영역 | 항목 | 설명 | 담당 | 예상 공수 |
|------|------|------|------|----------|
| FE/BE | | | | |

**🟢 Low (백로그)**
| 영역 | 항목 | 설명 | 담당 | 예상 공수 |
|------|------|------|------|----------|
| FE/BE | | | | |

**💡 신규 기능 제안 (New)**
| 영역 | 기능명 | 사용자 가치 | 구현 복잡도 | 권장 시기 |
|------|-------|------------|-----------|----------|
| FE | | 높음/중간/낮음 | 높음/중간/낮음 | |
| BE | | | | |
| 통합 | | | | |

---

## 6단계: 권장 다음 단계

### 기존 이슈 해결
1. **즉시**: Critical 이슈 해결 (보안, 데이터 손실 위험)
2. **1주 내**: High 우선순위 항목 및 API 계약 불일치 해결
3. **2주 내**: 부분 구현 기능 완성, 테스트 커버리지 확대

### 신규 기능 개발
4. **이번 스프린트**: Quick Win 신규 기능 1-2개 개발
5. **다음 스프린트**: Strategic 신규 기능 상세 기획
6. **로드맵 반영**: 분기별 신규 기능 마일스톤 설정

### 지속적 개선
7. **정기 갭 분석**: 스프린트마다 재실행
8. **사용자 피드백 수집**: 신규 기능 발굴 인풋으로 활용
9. **기술 트렌드 모니터링**: Next.js/Python 생태계 변화 추적

---

## 분석 시 참고사항

- 명세서와 코드 모두 최신 버전인지 확인
- 의도적으로 구현하지 않은 기능은 별도 표기
- 발견된 이슈는 GitHub Issues / Jira에 등록 권장
- **신규 기능 제안은 Product Owner/기획자와 함께 리뷰**
- 프론트엔드-백엔드 담당자 함께 리뷰 권장
- 정기적으로 (스프린트마다) 갭 분석 재실행 권장