---
name: code-efficiency
description: 소스코드의 구조적 건전성, 성능, 유지보수성을 종합 평가합니다. 모듈화, 재사용성, 관심사 분리, 알고리즘 효율성 등 100개 이상의 항목을 점검합니다. JavaScript, Python, Java, Go, Rust 등 모든 프로그래밍 언어에 적용 가능합니다. 분석 결과를 보고한 후 사용자와 협의하여 개선 범위를 합의합니다. 합의된 항목에 대해 단계별로 코드 개선을 수행하고 동작을 검증합니다.
---
# 코드 효율성 검사 및 개선

## 스킬 설명

**소스코드의 구조적 건전성, 성능, 유지보수성을 종합 평가하여 개선 기회를 발굴하고, 사용자와 협의를 거쳐 실제 코드 개선까지 수행합니다. 모듈화, 재사용성, 관심사 분리 등 구조적 품질부터 알고리즘 효율성, 메모리 관리까지 전방위 점검하며, 모든 프로그래밍 언어에 적용 가능한 범용 원칙과 언어별 최적화 기법을 함께 제공합니다.**

---

## 작업 프로세스
```
┌─────────────────────────────────────────────────────────────────────────────┐
│                        코드 효율성 개선 워크플로우                              │
├─────────────────────────────────────────────────────────────────────────────┤
│                                                                             │
│  ┌──────────┐    ┌──────────┐    ┌──────────┐    ┌──────────┐    ┌────────┐│
│  │ 1. 분석  │ ─▶ │ 2. 보고  │ ─▶ │ 3. 협의  │ ─▶ │ 4. 개선  │ ─▶ │5. 검증 ││
│  │ Analysis │    │ Report   │    │ Review   │    │ Refactor │    │ Verify ││
│  └──────────┘    └──────────┘    └──────────┘    └──────────┘    └────────┘│
│       │              │               │               │              │      │
│       ▼              ▼               ▼               ▼              ▼      │
│  코드 전체 스캔   개선사항 목록    사용자 검토     코드 수정      동작 확인   │
│  문제점 식별     우선순위 분류    범위 합의      단계별 적용    품질 비교   │
│                                                                             │
└─────────────────────────────────────────────────────────────────────────────┘
```

### 프로세스 상세

| 단계 | 활동 | 산출물 |
|------|------|--------|
| **1. 분석** | 코드 구조, 패턴, 성능 이슈 스캔 | 문제점 목록 |
| **2. 보고** | 발견사항 정리, 우선순위화 | 개선 보고서 |
| **3. 협의** | 사용자와 개선 범위/방향 논의 | 합의된 작업 목록 |
| **4. 개선** | 합의된 항목 코드 수정 | 개선된 코드 |
| **5. 검증** | 기능 동작 확인, 개선 효과 측정 | 검증 결과 |

---

## 1단계: 코드 분석 (Analysis)

### A. 구조적 건전성 평가 (Structural Health)

#### 모듈화 (Modularity)
- [ ] 단일 파일에 과도한 코드가 집중되어 있지 않은가 (300줄 이상 주의)
- [ ] 하나의 파일/모듈이 하나의 명확한 책임을 가지는가
- [ ] 관련 기능이 논리적으로 그룹화되어 있는가
- [ ] 순환 의존성(Circular Dependency)이 없는가
- [ ] 모듈 간 결합도(Coupling)가 낮은가
- [ ] 모듈 내 응집도(Cohesion)가 높은가

#### 재사용성 (Reusability)
- [ ] 중복 코드가 존재하는가 (DRY 원칙 위반)
- [ ] 공통 로직이 유틸리티/헬퍼로 추출되어 있는가
- [ ] 제네릭/추상화를 통해 범용성을 확보했는가
- [ ] 하드코딩된 값이 설정/상수로 분리되어 있는가
- [ ] 컴포넌트/함수가 다른 컨텍스트에서도 사용 가능한가

#### 관심사 분리 (Separation of Concerns)
- [ ] 데이터(Model)와 표현(View)이 분리되어 있는가
- [ ] 비즈니스 로직과 UI 로직이 혼재되어 있지 않은가
- [ ] 데이터 접근 계층이 비즈니스 로직과 분리되어 있는가
- [ ] 설정/환경 정보가 코드와 분리되어 있는가
- [ ] 크로스커팅 관심사(로깅, 인증, 에러처리)가 적절히 분리되어 있는가

#### 계층 구조 (Layered Architecture)
- [ ] 명확한 계층 구조가 존재하는가 (Presentation → Business → Data)
- [ ] 계층 간 의존성 방향이 올바른가 (상위 → 하위)
- [ ] 계층을 건너뛰는 호출이 없는가
- [ ] 각 계층의 역할이 명확한가

#### 의존성 관리 (Dependency Management)
- [ ] 의존성 주입(DI) 패턴을 활용하는가
- [ ] 구체 클래스보다 인터페이스/추상에 의존하는가
- [ ] 외부 라이브러리 의존성이 적절히 캡슐화되어 있는가
- [ ] 의존성 버전이 명시적으로 관리되는가

---

### B. 함수/메서드 품질 평가

#### 함수 설계
- [ ] 함수가 한 가지 작업만 수행하는가 (Single Responsibility)
- [ ] 함수 길이가 적절한가 (20-30줄 이내 권장)
- [ ] 매개변수 개수가 적절한가 (3개 이하 권장, 4개 이상 시 객체화 고려)
- [ ] 함수명이 동작을 명확히 설명하는가
- [ ] 부수 효과(Side Effect)가 명확히 드러나는가
- [ ] 순수 함수(Pure Function)로 작성 가능한가

#### 반환값 및 에러 처리
- [ ] 반환 타입이 일관적인가 (Union 타입 남용 주의)
- [ ] null/undefined 반환을 최소화하는가
- [ ] 에러 처리가 적절한 수준에서 이루어지는가
- [ ] 예외 발생 가능성이 문서화되어 있는가

#### 복잡도 관리
- [ ] 중첩 깊이가 3단계를 초과하지 않는가
- [ ] 조기 반환(Early Return)을 활용하는가
- [ ] 복잡한 조건문이 명확한 이름의 함수로 추출되어 있는가
- [ ] 순환 복잡도(Cyclomatic Complexity)가 10 이하인가

---

### C. 데이터 구조 및 상태 관리

#### 데이터 모델링
- [ ] 데이터 구조가 도메인을 적절히 표현하는가
- [ ] 불필요한 중첩이 없는가
- [ ] 데이터 정규화/비정규화가 적절한가
- [ ] 불변성(Immutability)을 활용하는가

#### 상태 관리
- [ ] 전역 상태가 최소화되어 있는가
- [ ] 상태 변경 지점이 명확한가
- [ ] 상태 동기화 이슈가 없는가
- [ ] 상태의 단일 진실 공급원(Single Source of Truth)이 존재하는가

#### 타입 안전성
- [ ] 타입이 명시적으로 정의되어 있는가 (타입 힌트, TypeScript 등)
- [ ] any/Object 등 광범위한 타입 사용을 피하는가
- [ ] null 안전성이 확보되어 있는가
- [ ] 타입 가드/타입 단언이 적절히 사용되는가

---

### D. 알고리즘 및 성능 효율성

#### 시간 복잡도
- [ ] 불필요한 O(n²) 이상의 반복이 없는가
- [ ] 중첩 루프 최적화 가능성 검토
- [ ] 조기 종료(Early Exit) 조건 활용
- [ ] 적절한 자료구조 선택 (배열 vs 해시맵 vs 트리)
- [ ] 정렬/검색 알고리즘 효율성

#### 공간 복잡도
- [ ] 불필요한 데이터 복사가 없는가
- [ ] 메모리 누수 가능성이 없는가
- [ ] 대용량 데이터 스트리밍/청크 처리 적용
- [ ] 캐싱 전략 적절성

#### I/O 효율성
- [ ] 불필요한 파일/네트워크 I/O가 없는가
- [ ] 배치 처리로 I/O 횟수 최소화
- [ ] 비동기 I/O 활용 가능성
- [ ] 커넥션 풀링 적용

#### 반복 및 순회 최적화
- [ ] 동일 데이터에 대한 중복 순회가 없는가
- [ ] 필터/맵/리듀스 체이닝 최적화
- [ ] 지연 평가(Lazy Evaluation) 활용 가능성
- [ ] 병렬 처리 가능성

---

### E. 코드 가독성 및 유지보수성

#### 네이밍
- [ ] 변수/함수/클래스명이 의도를 명확히 전달하는가
- [ ] 축약어 사용을 최소화하는가
- [ ] 일관된 네이밍 컨벤션을 따르는가
- [ ] 불리언 변수는 is/has/can 등으로 시작하는가
- [ ] 컬렉션 변수는 복수형을 사용하는가

#### 주석 및 문서화
- [ ] 코드 자체가 자기 문서화(Self-documenting)되어 있는가
- [ ] 복잡한 비즈니스 로직에 설명 주석이 있는가
- [ ] "왜(Why)" 를 설명하는 주석이 있는가 (What은 코드로)
- [ ] 공개 API에 문서화 주석이 있는가 (JSDoc, Docstring 등)
- [ ] 오래된/잘못된 주석이 없는가

#### 코드 포맷팅
- [ ] 일관된 들여쓰기와 공백 사용
- [ ] 적절한 줄 길이 (80-120자 권장)
- [ ] 논리적 블록 간 빈 줄로 구분
- [ ] 포매터/린터 설정 적용

---

### F. 에러 처리 및 견고성

#### 예외 처리
- [ ] 예외가 적절한 수준에서 처리되는가
- [ ] 빈 catch 블록이 없는가
- [ ] 에러 메시지가 명확하고 유용한가
- [ ] 예외 타입이 구체적인가 (범용 Exception 남용 금지)
- [ ] 리소스 정리가 보장되는가 (finally, using, with 등)

#### 입력 검증
- [ ] 외부 입력에 대한 유효성 검사가 있는가
- [ ] 경계값 검사가 이루어지는가
- [ ] null/undefined 체크가 적절한가
- [ ] 타입 검증이 이루어지는가

#### 방어적 프로그래밍
- [ ] 가정(Assumption)이 검증되는가 (assert, invariant)
- [ ] 실패 시 안전한 기본값 제공
- [ ] 외부 의존성 실패에 대한 대비

---

### G. 테스트 용이성 (Testability)

#### 테스트 가능한 설계
- [ ] 함수/클래스가 테스트하기 쉬운 크기인가
- [ ] 외부 의존성이 주입 가능한가 (모킹 용이)
- [ ] 전역 상태 의존이 최소화되어 있는가
- [ ] 비결정적 요소(시간, 난수)가 추상화되어 있는가

#### 테스트 커버리지
- [ ] 핵심 비즈니스 로직에 테스트가 있는가
- [ ] 엣지 케이스 테스트가 있는가
- [ ] 테스트가 독립적으로 실행 가능한가

---

### H. 보안 고려사항

#### 입력 보안
- [ ] SQL Injection 방지 (파라미터 바인딩)
- [ ] XSS 방지 (출력 이스케이프)
- [ ] 경로 조작 방지 (Path Traversal)
- [ ] 명령어 주입 방지

#### 데이터 보안
- [ ] 민감 정보 하드코딩 금지
- [ ] 로그에 민감 정보 노출 금지
- [ ] 암호화 필요 데이터 식별
- [ ] 접근 권한 검증

---

### I. 언어별 특화 점검

#### JavaScript/TypeScript
- [ ] 콜백 지옥 대신 async/await 사용
- [ ] == 대신 === 사용
- [ ] var 대신 const/let 사용
- [ ] 옵셔널 체이닝(?.)과 널 병합(??) 활용
- [ ] 불필요한 any 타입 제거
- [ ] 이벤트 리스너 정리

#### Python
- [ ] 리스트 컴프리헨션 적절히 활용
- [ ] 제너레이터로 메모리 효율화
- [ ] 컨텍스트 매니저(with) 활용
- [ ] 타입 힌트 적용
- [ ] f-string 활용
- [ ] Pythonic한 관용구 사용

#### Java/Kotlin
- [ ] Stream API 활용
- [ ] Optional로 null 처리
- [ ] 불변 객체 활용
- [ ] 람다/메서드 레퍼런스 활용
- [ ] 적절한 컬렉션 타입 선택

#### Go
- [ ] 에러 처리 일관성
- [ ] goroutine 누수 방지
- [ ] defer로 리소스 정리
- [ ] 인터페이스 활용

#### Rust
- [ ] 소유권/빌림 규칙 준수
- [ ] unwrap() 남용 금지
- [ ] 적절한 에러 타입 사용
- [ ] 라이프타임 명시

#### SQL
- [ ] 인덱스 활용 여부
- [ ] N+1 쿼리 문제
- [ ] SELECT * 지양
- [ ] 적절한 JOIN 사용

---

## 2단계: 개선 보고서 작성 (Report)

### 보고서 템플릿
```markdown
# 코드 효율성 분석 보고서

## 분석 개요
- **분석 대상**: [파일/모듈/프로젝트명]
- **분석 일시**: [날짜]
- **코드 규모**: [파일 수, 라인 수]
- **주요 언어**: [언어명]

## 요약 대시보드
```
전체 점수: __/100

항목별 점수:
├── 구조적 건전성: __/20
├── 함수 품질: __/15
├── 데이터 관리: __/15
├── 성능 효율성: __/20
├── 가독성: __/15
└── 견고성: __/15

발견된 이슈:
├── 🔴 Critical: __ 건
├── 🟠 Major: __ 건
├── 🟡 Minor: __ 건
└── 💡 Suggestion: __ 건
```

## 상세 발견사항

### 🔴 Critical (즉시 개선 필요)

| # | 위치 | 이슈 | 현재 코드 | 개선 방향 | 예상 효과 |
|---|------|------|----------|----------|----------|
| 1 | | | | | |

### 🟠 Major (중요 개선사항)

| # | 위치 | 이슈 | 현재 코드 | 개선 방향 | 예상 효과 |
|---|------|------|----------|----------|----------|
| 1 | | | | | |

### 🟡 Minor (권장 개선사항)

| # | 위치 | 이슈 | 현재 코드 | 개선 방향 | 예상 효과 |
|---|------|------|----------|----------|----------|
| 1 | | | | | |

### 💡 Suggestion (제안사항)

| # | 위치 | 제안 | 기대 효과 |
|---|------|------|----------|
| 1 | | | |

## 개선 우선순위 권장

1. **즉시**: [항목들]
2. **이번 주**: [항목들]
3. **다음 스프린트**: [항목들]
4. **백로그**: [항목들]
```

---

## 3단계: 사용자 협의 (Review)

### 협의 프로세스
```
┌─────────────────────────────────────────────────────────┐
│                    협의 체크리스트                        │
├─────────────────────────────────────────────────────────┤
│                                                         │
│  □ 보고서 내용 공유 및 설명                               │
│  □ 각 이슈에 대한 사용자 의견 확인                         │
│  □ 개선 범위 합의 (전체 / 선택적)                         │
│  □ 개선 방향 합의 (보수적 / 적극적)                       │
│  □ 제외 항목 확인 (의도적 설계, 레거시 유지 등)            │
│  □ 우선순위 조정                                         │
│  □ 작업 단위 결정 (한 번에 / 단계별)                      │
│                                                         │
└─────────────────────────────────────────────────────────┘
```

### 협의 질문 목록

**범위 확인**
- "보고된 이슈 중 이번에 개선할 항목을 선택해 주세요."
- "제외해야 할 항목이 있나요? (의도적 설계, 외부 제약 등)"
- "추가로 검토가 필요한 부분이 있나요?"

**방향 확인**
- "리팩토링 수준을 어느 정도로 할까요? (최소 변경 / 구조 개선 포함)"
- "기존 인터페이스(함수 시그니처, API)를 유지해야 하나요?"
- "테스트 코드 추가/수정도 함께 진행할까요?"

**제약 확인**
- "변경하면 안 되는 파일/영역이 있나요?"
- "호환성을 유지해야 하는 버전이 있나요?"
- "성능/메모리 제약사항이 있나요?"

### 합의 결과 기록
```markdown
## 개선 작업 합의 내역

### 진행할 항목
| # | 이슈 | 개선 방향 | 비고 |
|---|------|----------|------|
| 1 | | | |

### 제외 항목
| # | 이슈 | 제외 사유 |
|---|------|----------|
| 1 | | |

### 작업 제약사항
- 

### 작업 순서
1. 
2. 
3. 
```

---

## 4단계: 코드 개선 수행 (Refactor)

### 개선 원칙
```
┌─────────────────────────────────────────────────────────┐
│                    안전한 리팩토링 원칙                    │
├─────────────────────────────────────────────────────────┤
│                                                         │
│  1. 작은 단위로 변경 (한 번에 하나의 개선만)               │
│  2. 동작 변경 없이 구조만 개선 (기능 추가 분리)            │
│  3. 각 변경 후 동작 확인 가능한 상태 유지                  │
│  4. 변경 전 코드 백업/버전 관리                           │
│  5. 변경 의도를 명확히 기록                               │
│                                                         │
└─────────────────────────────────────────────────────────┘
```

### 개선 작업 유형별 가이드

#### 유형 1: 함수 추출 (Extract Function)

**Before**
```
[긴 함수 또는 중복 코드 블록]
```

**After**
```
[명확한 이름의 별도 함수로 추출]
[원래 위치에서 함수 호출]
```

**체크포인트**
- [ ] 추출된 함수의 책임이 명확한가
- [ ] 함수명이 동작을 설명하는가
- [ ] 매개변수가 적절한가
- [ ] 원래 동작이 유지되는가

#### 유형 2: 조건문 단순화 (Simplify Conditionals)

**Before**
```
[중첩된 if-else 또는 복잡한 조건]
```

**After**
```
[조기 반환, 가드 절, 조건 추출 적용]
```

**체크포인트**
- [ ] 모든 분기가 유지되는가
- [ ] 가독성이 향상되었는가
- [ ] 엣지 케이스가 처리되는가

#### 유형 3: 중복 제거 (Remove Duplication)

**Before**
```
[여러 위치의 유사/동일 코드]
```

**After**
```
[공통 함수/모듈로 추출]
[각 위치에서 공통 코드 호출]
```

**체크포인트**
- [ ] 모든 사용처가 업데이트되었는가
- [ ] 미묘한 차이점이 처리되었는가
- [ ] 추상화 수준이 적절한가

#### 유형 4: 데이터 구조 개선 (Improve Data Structure)

**Before**
```
[비효율적 자료구조 또는 중복 데이터]
```

**After**
```
[적절한 자료구조 적용]
[데이터 정규화/구조화]
```

**체크포인트**
- [ ] 데이터 접근 패턴에 적합한가
- [ ] 기존 데이터 마이그레이션 고려
- [ ] 관련 코드 모두 업데이트

#### 유형 5: 성능 최적화 (Optimize Performance)

**Before**
```
[비효율적 알고리즘/패턴]
```

**After**
```
[최적화된 구현]
```

**체크포인트**
- [ ] 실제 성능 향상 측정
- [ ] 가독성과의 균형 고려
- [ ] 엣지 케이스 동작 유지

### 개선 작업 기록
```markdown
## 개선 작업 로그

### 변경 #1: [제목]
- **대상**: [파일:라인]
- **유형**: [함수 추출 / 조건문 단순화 / 중복 제거 / 구조 개선 / 성능 최적화]
- **변경 전**: 
```
[코드]
```
- **변경 후**:
```
[코드]
```
- **변경 사유**: 
- **영향 범위**: 
- **확인 결과**: ✅ 동작 확인 완료
```

---

## 5단계: 검증 (Verify)

### 검증 체크리스트

#### 기능 검증
- [ ] 기존 기능이 모두 정상 동작하는가
- [ ] 엣지 케이스가 처리되는가
- [ ] 에러 처리가 유지되는가
- [ ] 기존 테스트가 통과하는가

#### 품질 검증
- [ ] 린터/포매터 검사 통과
- [ ] 타입 검사 통과 (해당 시)
- [ ] 코드 복잡도 감소 확인
- [ ] 중복 코드 감소 확인

#### 성능 검증 (해당 시)
- [ ] 실행 시간 비교
- [ ] 메모리 사용량 비교
- [ ] I/O 횟수 비교

### 개선 효과 요약
```markdown
## 개선 결과 요약

### 정량적 개선
| 지표 | 개선 전 | 개선 후 | 변화 |
|------|--------|--------|------|
| 총 라인 수 | | | |
| 함수 평균 길이 | | | |
| 중복 코드 블록 | | | |
| 순환 복잡도 평균 | | | |
| 최대 중첩 깊이 | | | |

### 정성적 개선
- **구조**: 
- **가독성**: 
- **유지보수성**: 
- **테스트 용이성**: 

### 추가 권장사항
- 
```

---

## 부록: 코드 스멜(Code Smell) 빠른 참조

### 구조적 스멜
| 스멜 | 증상 | 해결책 |
|------|------|--------|
| 긴 함수 | 50줄 이상 | 함수 추출 |
| 긴 매개변수 목록 | 4개 이상 | 매개변수 객체 도입 |
| 전역 변수 남용 | 여러 곳에서 전역 상태 변경 | 의존성 주입, 캡슐화 |
| 신 클래스 | 모든 것을 아는 거대 클래스 | 클래스 분리 |
| 기능 편애 | 다른 클래스 데이터를 과도하게 사용 | 메서드 이동 |

### 중복 스멜
| 스멜 | 증상 | 해결책 |
|------|------|--------|
| 중복 코드 | 동일/유사 코드 블록 반복 | 함수/모듈 추출 |
| 유사 클래스 | 거의 같은 클래스 여러 개 | 상속/합성 활용 |
| 매직 넘버 | 의미 불명확한 숫자/문자열 | 상수 추출 |

### 복잡도 스멜
| 스멜 | 증상 | 해결책 |
|------|------|--------|
| 중첩 조건문 | 깊은 if-else 중첩 | 가드 절, 조기 반환 |
| 복잡한 불리언 | 이해하기 어려운 조건식 | 설명 변수/함수 도입 |
| switch 남용 | 긴 switch/case 문 | 다형성, 전략 패턴 |

### 데이터 스멜
| 스멜 | 증상 | 해결책 |
|------|------|--------|
| 데이터 덩어리 | 항상 함께 다니는 데이터 | 클래스/구조체 도입 |
| 기본 타입 집착 | 객체 대신 기본 타입 남용 | 값 객체 도입 |
| null 반환 | null을 빈번하게 반환 | Optional, Null Object |

---

## 부록: 리팩토링 패턴 카탈로그

### 함수 수준
- **함수 추출 (Extract Function)**: 코드 블록을 별도 함수로
- **함수 인라인 (Inline Function)**: 불필요한 함수 제거
- **변수 추출 (Extract Variable)**: 복잡한 표현식에 이름 부여
- **매개변수 객체 도입**: 관련 매개변수를 객체로 그룹화

### 조건문 수준
- **조건문 분해 (Decompose Conditional)**: 복잡한 조건을 함수로
- **가드 절 (Guard Clauses)**: 중첩 조건을 조기 반환으로
- **조건부 로직을 다형성으로**: switch를 객체로

### 클래스/모듈 수준
- **클래스 추출 (Extract Class)**: 책임 분리
- **메서드 이동 (Move Method)**: 적절한 클래스로 이동
- **위임 숨기기 (Hide Delegate)**: 중간 객체 캡슐화

---

## 분석 시 참고사항

- 모든 개선은 사용자 동의 후 진행
- 한 번에 너무 많은 변경 지양
- 변경 전 동작하는 코드 보존
- 의도적 설계 결정 존중
- 레거시 코드는 점진적 개선
- 성능 최적화는 측정 후 진행
```

---

## 스킬 사용 방법

Claude Code에서:
```
/code-efficiency

분석 대상: @src/
```

또는 특정 파일:
```
/code-efficiency

분석 대상: @src/utils/helpers.ts