---
name: ux-improve
description: 현재 구현된 소스코드와 UI 리소스를 분석하여 사용자 경험 개선 기회를 발굴합니다. 사용자 여정, 사용자 스토리, 닐슨의 10가지 휴리스틱 등 다양한 관점에서 UX 문제점을 진단합니다. 필터/검색 누락, 정보 배치 부적절, 피드백 미흡 등 실질적인 개선사항을 도출합니다. 발견된 이슈를 우선순위별로 정리하여 사용자와 협의한 후 합의된 항목을 구현합니다. 기능 추가, 컴포넌트 이동, 기본값 변경 등 실제 코드 수정까지 수행하고 검증합니다.
---
# UX 개선점 발굴 및 구현

## 스킬 설명

**현재 구현된 소스코드와 UI 리소스를 분석하여 사용자 경험 개선 기회를 발굴합니다. 사용자 여정, 사용자 스토리, 휴리스틱 평가 등 다양한 관점에서 UX 문제점을 진단합니다. 발견된 개선사항을 사용자와 협의한 후 실제 구현까지 수행합니다. 단순 UI 수정부터 화면 구조 재배치, 신규 기능 추가까지 포괄적으로 다룹니다.**

---

## 작업 프로세스
```
┌─────────────────────────────────────────────────────────────────────────────┐
│                        UX 개선 워크플로우                                     │
├─────────────────────────────────────────────────────────────────────────────┤
│                                                                             │
│  ┌──────────┐    ┌──────────┐    ┌──────────┐    ┌──────────┐    ┌────────┐│
│  │ 1. 현황  │ ─▶ │ 2. 분석  │ ─▶ │ 3. 제안  │ ─▶ │ 4. 협의  │ ─▶ │5. 구현 ││
│  │ 파악    │    │ 진단     │    │ 정리     │    │ 합의     │    │ 검증   ││
│  └──────────┘    └──────────┘    └──────────┘    └──────────┘    └────────┘│
│       │              │               │               │              │      │
│       ▼              ▼               ▼               ▼              ▼      │
│   화면/기능 파악   UX 문제 식별    개선안 작성     범위 합의     코드 수정   │
│   사용자 흐름     패턴 분석       우선순위화      방향 결정     동작 확인   │
│                                                                             │
└─────────────────────────────────────────────────────────────────────────────┘
```

---

## 1단계: 현황 파악

### A. 화면 및 기능 인벤토리

#### 화면 목록 작성
| 화면명 | 경로 | 주요 기능 | 대상 사용자 |
|--------|------|----------|------------|
| Dashboard | /dashboard | 요약 정보 표시 | 일반 사용자 |
| Statistics | /statistics | 통계 조회 | 일반 사용자 |
| Admin | /admin | 관리 기능 | 관리자 |
| Settings | /settings | 설정 변경 | 전체 |

#### 컴포넌트 파악
- [ ] 공통 컴포넌트 목록 (Header, Sidebar, Modal 등)
- [ ] 페이지별 고유 컴포넌트
- [ ] 폼 요소 및 입력 컴포넌트
- [ ] 데이터 표시 컴포넌트 (테이블, 차트, 카드 등)

#### 데이터 흐름 파악
- [ ] API 엔드포인트별 사용 화면
- [ ] 상태 관리 구조
- [ ] 데이터 갱신 주기 및 방식

### B. 사용자 유형 정의
```markdown
## 사용자 페르소나

### 페르소나 1: [이름/역할]
- **목표**: 
- **주요 사용 기능**: 
- **사용 빈도**: 
- **기술 수준**: 

### 페르소나 2: [이름/역할]
- **목표**: 
- **주요 사용 기능**: 
- **사용 빈도**: 
- **기술 수준**: 
```

---

## 2단계: UX 분석 및 진단

### A. 사용자 여정 분석 (User Journey)

#### 여정 맵 템플릿
```
┌─────────────────────────────────────────────────────────────────────────────┐
│ 사용자 여정: [목표 행동]                                                      │
├─────────────────────────────────────────────────────────────────────────────┤
│                                                                             │
│  단계    │ 인지 → 진입 → 탐색 → 실행 → 완료 → 재방문                         │
│          │                                                                  │
│  화면    │                                                                  │
│          │                                                                  │
│  행동    │                                                                  │
│          │                                                                  │
│  감정    │  😊 ───── 😐 ───── 😕 ───── 😊                                   │
│          │                                                                  │
│  Pain    │  ⚠️                ⚠️                                            │
│  Points  │                                                                  │
│          │                                                                  │
│  기회    │  💡                💡        💡                                   │
│                                                                             │
└─────────────────────────────────────────────────────────────────────────────┘
```

#### 핵심 여정 점검

**온보딩 여정**
- [ ] 첫 방문 시 사용자가 무엇을 해야 하는지 명확한가
- [ ] 핵심 기능까지 도달하는 단계가 최소화되어 있는가
- [ ] 빈 상태(Empty State)에서 안내가 제공되는가
- [ ] 튜토리얼/가이드가 필요한가

**핵심 작업 여정**
- [ ] 가장 빈번한 작업의 단계 수는 적절한가
- [ ] 불필요한 클릭/입력이 없는가
- [ ] 진행 상태가 명확히 표시되는가
- [ ] 완료 후 피드백이 제공되는가

**이탈 지점 분석**
- [ ] 사용자가 포기할 만한 복잡한 단계가 있는가
- [ ] 에러 발생 시 복구 경로가 명확한가
- [ ] 되돌아가기가 쉬운가

### B. 사용자 스토리 기반 분석

#### 사용자 스토리 점검 템플릿
```markdown
## 사용자 스토리 #[번호]

**스토리**: [역할]로서, [목표]를 위해, [기능]을 원한다.

**현재 상태**:
- 지원 여부: ✅ 완전 지원 / ⚠️ 부분 지원 / ❌ 미지원
- 구현 화면: 
- 필요 단계 수: 

**문제점**:
- 

**개선 제안**:
- 
```

#### 핵심 사용자 스토리 예시

| # | 사용자 스토리 | 현재 상태 | 문제점 |
|---|--------------|----------|--------|
| 1 | 사용자로서, 특정 기간의 통계를 보고 싶다 | ⚠️ 부분 | 기간 선택 불가 |
| 2 | 관리자로서, 활성 사용자를 한눈에 파악하고 싶다 | ⚠️ 부분 | Admin에 숨겨져 있음 |
| 3 | 사용자로서, 최근 트렌드를 빠르게 확인하고 싶다 | ⚠️ 부분 | 기본 기간이 너무 김 |

### C. 휴리스틱 평가 (Nielsen's 10 Heuristics)

#### 1. 시스템 상태의 가시성
- [ ] 현재 위치가 명확한가 (네비게이션 하이라이트)
- [ ] 로딩 상태가 표시되는가
- [ ] 작업 진행률이 표시되는가
- [ ] 데이터 갱신 시점이 표시되는가

#### 2. 시스템과 실세계의 일치
- [ ] 용어가 사용자에게 익숙한가
- [ ] 아이콘이 직관적인가
- [ ] 정보 순서가 자연스러운가
- [ ] 날짜/시간 형식이 지역에 맞는가

#### 3. 사용자 제어와 자유
- [ ] 실행 취소(Undo)가 가능한가
- [ ] 취소 버튼이 명확한가
- [ ] 이전 단계로 돌아갈 수 있는가
- [ ] 모달/팝업을 쉽게 닫을 수 있는가

#### 4. 일관성과 표준
- [ ] 동일 기능이 동일하게 표현되는가
- [ ] 버튼 스타일이 일관적인가
- [ ] 용어 사용이 일관적인가
- [ ] 레이아웃 패턴이 일관적인가

#### 5. 오류 예방
- [ ] 위험한 작업 전 확인을 요청하는가
- [ ] 입력 형식 힌트가 제공되는가
- [ ] 실시간 유효성 검사가 있는가
- [ ] 자동 저장이 지원되는가

#### 6. 기억보다 인식
- [ ] 옵션이 보이는 곳에 있는가
- [ ] 최근 항목/자주 쓰는 항목이 표시되는가
- [ ] 툴팁/힌트가 제공되는가
- [ ] 검색/필터 조건이 유지되는가

#### 7. 사용의 유연성과 효율성
- [ ] 단축키가 지원되는가
- [ ] 고급 사용자를 위한 빠른 경로가 있는가
- [ ] 자주 쓰는 기능에 빠르게 접근 가능한가
- [ ] 일괄 처리가 가능한가

#### 8. 미학적이고 미니멀한 디자인
- [ ] 불필요한 정보가 표시되지 않는가
- [ ] 시각적 계층 구조가 명확한가
- [ ] 여백이 적절한가
- [ ] 색상 사용이 의미 있는가

#### 9. 오류 인식, 진단, 복구 지원
- [ ] 에러 메시지가 명확한가
- [ ] 해결 방법이 안내되는가
- [ ] 에러 발생 위치가 표시되는가
- [ ] 입력 내용이 보존되는가

#### 10. 도움말과 문서화
- [ ] 도움말에 쉽게 접근 가능한가
- [ ] 컨텍스트에 맞는 도움말이 있는가
- [ ] 검색 가능한 문서가 있는가
- [ ] FAQ가 제공되는가

### D. 화면별 상세 분석

#### 화면 분석 템플릿
```markdown
## 화면 분석: [화면명]

### 기본 정보
- **경로**: 
- **목적**: 
- **대상 사용자**: 

### 현재 구성요소
| 영역 | 컴포넌트 | 기능 | 비고 |
|------|---------|------|------|
| | | | |

### 발견된 UX 이슈

#### 🔴 Critical
| 이슈 | 영향 | 개선안 |
|------|------|--------|
| | | |

#### 🟠 Major
| 이슈 | 영향 | 개선안 |
|------|------|--------|
| | | |

#### 🟡 Minor
| 이슈 | 영향 | 개선안 |
|------|------|--------|
| | | |

### 누락된 기능 제안
| 기능 | 필요성 | 기대 효과 |
|------|--------|----------|
| | | |
```

### E. 데이터 조회/필터링 패턴 점검

#### 검색 및 필터
- [ ] 검색 기능이 필요한 곳에 있는가
- [ ] 필터 옵션이 충분한가
- [ ] 기간 선택이 필요한 곳에 있는가
- [ ] 필터 초기화가 쉬운가
- [ ] 적용된 필터가 명확히 표시되는가

#### 기간 선택 패턴
| 화면 | 기간 선택 | 기본값 | 문제점 | 개선안 |
|------|----------|--------|--------|--------|
| Statistics | ❌ 없음 | 전체 | 데이터 과다 | 기간 필터 추가 |
| Trends | ✅ 있음 | 30일 | 너무 김 | 7일로 변경 |

#### 정렬 패턴
- [ ] 정렬 가능한 컬럼이 명확한가
- [ ] 현재 정렬 상태가 표시되는가
- [ ] 기본 정렬이 적절한가

### F. 정보 배치 적절성 분석

#### 화면 간 기능 배치 검토
```markdown
## 기능 배치 분석

### 현재 배치
| 기능 | 현재 위치 | 사용 빈도 | 대상 사용자 |
|------|----------|----------|------------|
| Active Top Users | Admin | 높음 | 전체 |
| System Logs | Admin | 낮음 | 관리자 |
| 30-Day Trends | Dashboard | 높음 | 전체 |

### 배치 문제점
| 기능 | 문제 | 권장 위치 | 사유 |
|------|------|----------|------|
| Active Top Users | 관리자만 접근 가능 | Dashboard | 일반 사용자도 필요 |

### 권장 화면 구조
```
Dashboard (일반 사용자 중심)
├── 요약 카드
├── Active Top Users (이동)
├── 최근 활동
└── 트렌드 차트

Admin (관리자 전용)
├── 사용자 관리
├── 시스템 설정
└── 로그/감사
```
```

### G. 인터랙션 패턴 분석

#### 피드백 및 응답
- [ ] 클릭/탭에 즉각적 피드백이 있는가
- [ ] 성공/실패 메시지가 명확한가
- [ ] 로딩 시간이 길 때 진행 표시가 있는가
- [ ] 비활성 버튼이 명확히 구분되는가

#### 폼 경험
- [ ] 필수 필드가 명확히 표시되는가
- [ ] 실시간 유효성 검사가 있는가
- [ ] 에러 위치로 스크롤되는가
- [ ] 자동 완성/제안이 있는가

#### 목록/테이블 경험
- [ ] 페이지네이션이 적절한가
- [ ] 무한 스크롤이 필요한가
- [ ] 선택/다중 선택이 직관적인가
- [ ] 빈 상태 메시지가 있는가

---

## 3단계: 개선 제안 정리

### 개선 제안서 템플릿
```markdown
# UX 개선 제안서

## 분석 개요
- **분석 대상**: [프로젝트/화면]
- **분석 일시**: [날짜]
- **분석 범위**: [화면 수, 기능 수]

## 요약
```
발견된 이슈: __ 건
├── 🔴 Critical: __ 건
├── 🟠 Major: __ 건
├── 🟡 Minor: __ 건
└── 💡 신규 제안: __ 건

영향받는 화면: __ 개
예상 개선 효과: [간략 설명]
```

## 상세 개선 제안

### 🔴 Critical (즉시 개선)

#### UX-001: [제목]
- **화면**: 
- **현재 상태**: 
- **문제점**: 
- **사용자 영향**: 
- **개선안**: 
- **구현 복잡도**: 낮음 / 중간 / 높음
- **기대 효과**: 

### 🟠 Major (주요 개선)

#### UX-002: [제목]
...

### 🟡 Minor (권장 개선)

#### UX-003: [제목]
...

### 💡 신규 기능 제안

#### NEW-001: [제목]
- **대상 화면**: 
- **제안 기능**: 
- **필요성**: 
- **사용자 스토리**: [역할]로서, [목표]를 위해, [기능]을 원한다
- **구현 복잡도**: 
- **기대 효과**: 
```

### 개선 우선순위 매트릭스
```
┌─────────────────────────────────────────────────────────┐
│                  개선 우선순위 매트릭스                    │
├─────────────────────────────────────────────────────────┤
│                                                         │
│         높음 │  ⭐ 즉시    │  📋 계획    │              │
│   사용자     │   개선      │   수립      │              │
│   영향      ├─────────────┼─────────────┤              │
│         낮음 │  ✅ 틈틈이  │  📝 백로그  │              │
│              │   처리      │   등록      │              │
│              └─────────────┴─────────────┘              │
│                  낮음          높음                      │
│                     구현 노력                           │
└─────────────────────────────────────────────────────────┘
```

---

## 4단계: 사용자 협의

### 협의 체크리스트
```
┌─────────────────────────────────────────────────────────┐
│                    협의 체크리스트                        │
├─────────────────────────────────────────────────────────┤
│                                                         │
│  □ 개선 제안서 내용 공유 및 설명                          │
│  □ 각 제안에 대한 사용자 의견 확인                        │
│  □ 비즈니스 우선순위와 조율                               │
│  □ 개선 범위 합의 (전체 / 선택적)                        │
│  □ 제외 항목 확인 (의도적 설계, 기술 제약 등)             │
│  □ 디자인 방향 합의 (기존 유지 / 새로운 패턴)            │
│  □ 작업 순서 결정                                        │
│                                                         │
└─────────────────────────────────────────────────────────┘
```

### 협의 질문 목록

**범위 확인**
- "제안된 개선 중 이번에 진행할 항목을 선택해 주세요."
- "제외해야 할 항목이 있나요?"
- "추가로 고려해야 할 UX 이슈가 있나요?"

**방향 확인**
- "기존 디자인 패턴을 유지할까요, 새로운 패턴을 도입할까요?"
- "컴포넌트 라이브러리 사용에 제약이 있나요?"
- "반응형 대응이 필요한가요?"

**우선순위 확인**
- "가장 시급한 개선은 무엇인가요?"
- "사용자 피드백이 많았던 부분이 있나요?"
- "비즈니스 목표와 연결되는 개선은?"

### 합의 결과 기록
```markdown
## UX 개선 작업 합의 내역

### 진행할 항목
| # | 제안 | 우선순위 | 비고 |
|---|------|---------|------|
| UX-001 | | | |
| NEW-001 | | | |

### 제외 항목
| # | 제안 | 제외 사유 |
|---|------|----------|
| | | |

### 디자인 가이드라인
- 색상: 
- 컴포넌트: 
- 반응형: 

### 작업 순서
1. 
2. 
3. 
```

---

## 5단계: 구현 및 검증

### A. 구현 유형별 가이드

#### 유형 1: 필터/검색 기능 추가

**예시: Statistics 화면에 기간 필터 추가**
```markdown
### 구현 계획
- **대상 파일**: /pages/statistics.tsx, /components/DateRangePicker.tsx
- **변경 내용**:
  1. DateRangePicker 컴포넌트 생성/활용
  2. 기간 상태 관리 추가
  3. API 호출 시 기간 파라미터 전달
  4. 기본값 설정 (최근 7일)

### 체크포인트
- [ ] 날짜 선택 UI가 직관적인가
- [ ] 프리셋 제공 (오늘, 7일, 30일, 사용자 지정)
- [ ] 선택된 기간이 명확히 표시되는가
- [ ] 잘못된 기간 선택 방지 (종료일 > 시작일)
```

#### 유형 2: 컴포넌트 위치 이동

**예시: Active Top Users를 Dashboard로 이동**
```markdown
### 구현 계획
- **원본**: /pages/admin/index.tsx
- **대상**: /pages/dashboard/index.tsx
- **변경 내용**:
  1. 컴포넌트 추출 (재사용 가능하게)
  2. Dashboard에 배치
  3. 필요시 Admin에서 제거 또는 유지
  4. 권한 처리 확인

### 체크포인트
- [ ] 컴포넌트가 독립적으로 동작하는가
- [ ] 데이터 페칭이 올바르게 되는가
- [ ] 레이아웃에 잘 맞는가
- [ ] 기존 기능이 유지되는가
```

#### 유형 3: 기본값/설정 변경

**예시: 30-Day Trends 기본 기간을 7일로 변경**
```markdown
### 구현 계획
- **대상 파일**: /components/TrendsChart.tsx
- **변경 내용**:
  1. 기본 기간 상수 변경 (30 → 7)
  2. 기간 선택 옵션 추가
  3. URL 파라미터로 기간 유지

### 체크포인트
- [ ] 기본값이 7일로 적용되는가
- [ ] 사용자가 다른 기간 선택 가능한가
- [ ] 페이지 새로고침 시 선택 유지되는가
```

#### 유형 4: 새로운 UI 컴포넌트 추가
```markdown
### 구현 계획
- **신규 파일**: /components/[ComponentName].tsx
- **사용 위치**: 
- **변경 내용**:
  1. 컴포넌트 설계
  2. 구현
  3. 페이지에 통합
  4. 스타일링

### 체크포인트
- [ ] 디자인 시스템과 일관적인가
- [ ] 재사용 가능하게 설계되었는가
- [ ] 반응형 대응이 되는가
- [ ] 접근성이 고려되었는가
```

### B. 구현 작업 기록
```markdown
## 구현 로그

### 변경 #1: [제목]
- **관련 제안**: UX-001
- **변경 파일**: 
- **변경 내용**:
```
[코드 또는 설명]
```
- **확인 결과**: ✅ / ❌
- **스크린샷**: (해당시)
```

### C. 검증 체크리스트

#### 기능 검증
- [ ] 새 기능이 의도대로 동작하는가
- [ ] 기존 기능이 영향받지 않았는가
- [ ] 다양한 데이터 상태에서 정상 동작하는가
- [ ] 에러 상황이 적절히 처리되는가

#### UX 검증
- [ ] 사용 흐름이 자연스러운가
- [ ] 피드백이 명확한가
- [ ] 로딩/빈 상태가 처리되는가
- [ ] 접근성이 유지되는가

#### 크로스 브라우저/디바이스
- [ ] 주요 브라우저에서 동작하는가
- [ ] 모바일 화면에서 적절한가
- [ ] 다양한 화면 크기에서 레이아웃이 유지되는가

### D. 개선 효과 요약
```markdown
## 개선 결과 요약

### 완료된 개선
| # | 제안 | 상태 | 비고 |
|---|------|------|------|
| UX-001 | 기간 필터 추가 | ✅ 완료 | |
| UX-002 | 컴포넌트 이동 | ✅ 완료 | |
| NEW-001 | 신규 기능 | ✅ 완료 | |

### 사용자 경험 개선 효과
| 지표 | 개선 전 | 개선 후 |
|------|--------|--------|
| 목표 달성 단계 수 | | |
| 주요 기능 접근성 | | |
| 정보 탐색 용이성 | | |

### 추가 권장사항
- 
```

---

## 부록: UX 패턴 빠른 참조

### 데이터 조회 패턴

| 상황 | 권장 패턴 |
|------|----------|
| 대량 데이터 | 페이지네이션 + 필터 |
| 실시간 피드 | 무한 스크롤 |
| 기간 기반 데이터 | 기간 선택기 (프리셋 + 커스텀) |
| 검색 필요 | 검색창 + 자동완성 |

### 기간 선택 기본값 가이드

| 데이터 유형 | 권장 기본값 |
|------------|------------|
| 실시간 모니터링 | 최근 1시간 / 24시간 |
| 일반 트렌드 | 최근 7일 |
| 리포트/분석 | 최근 30일 / 이번 달 |
| 히스토리 조회 | 전체 (페이지네이션과 함께) |

### 정보 배치 가이드

| 정보 유형 | 권장 위치 |
|----------|----------|
| 핵심 지표/요약 | Dashboard 상단 |
| 상세 데이터 | 전용 페이지 |
| 관리자 전용 | Admin 섹션 |
| 설정/환경 | Settings |
| 자주 사용하는 기능 | 사이드바/헤더 |

### 피드백 패턴

| 상황 | 권장 피드백 |
|------|-----------|
| 성공 | 토스트 메시지 (자동 닫힘) |
| 경고 | 인라인 경고 또는 모달 |
| 에러 | 인라인 에러 + 해결 방법 |
| 확인 필요 | 확인 모달 |
| 긴 작업 | 프로그레스 바/스피너 |

---

## 부록: 자주 발견되는 UX 개선 기회

### 필터/검색 관련
- [ ] 기간 선택 기능 누락
- [ ] 검색 결과 하이라이트 없음
- [ ] 필터 초기화 버튼 없음
- [ ] 적용된 필터 표시 없음
- [ ] 검색어 자동완성 없음

### 데이터 표시 관련
- [ ] 빈 상태 안내 없음
- [ ] 로딩 상태 표시 없음
- [ ] 데이터 갱신 시점 불명확
- [ ] 정렬 기능 없음
- [ ] 내보내기 기능 없음

### 네비게이션 관련
- [ ] 현재 위치 표시 불명확
- [ ] 뒤로가기 시 상태 손실
- [ ] 깊은 링크 미지원
- [ ] 브레드크럼 없음

### 폼 관련
- [ ] 실시간 유효성 검사 없음
- [ ] 저장 확인 메시지 없음
- [ ] 자동 저장 없음
- [ ] 필수 필드 표시 불명확

### 접근성 관련
- [ ] 키보드 네비게이션 미지원
- [ ] 포커스 표시 불명확
- [ ] 색상만으로 상태 구분
- [ ] 대체 텍스트 누락

---

## 분석 시 참고사항

- 실제 사용 시나리오 기준으로 분석
- 비즈니스 목표와 UX 개선 연결
- 기술 제약사항 미리 파악
- 점진적 개선 권장 (Big Bang 지양)
- 개선 후 사용자 피드백 수집 권장
```

---

## 스킬 사용 방법

Claude Code에서:
```
/ux-improve

분석 대상: @src/pages/ @src/components/