---
name: code-refactoring-skill
description: 구조적 및 스타일적 리팩토링을 수행하는 중급 및 고급 개발자를 위해 체계적이고 우선순위가 지정된 리팩토링 계획, 실행 가능한 코드 변경 제안, 체크리스트 기반의 지침을 제공합니다.
---
name: code-refactoring-skill
description: Provides structured, prioritized refactoring plans, actionable code-change suggestions, and checklist-driven guidance for mid-to-senior developers doing structural and stylistic refactors

# Code Refactoring Skill

Skill purpose

This Skill helps mid-to-senior developers perform safe, maintainable refactors. It produces: a prioritized step-by-step refactoring plan, small batch change suggestions (with diffs or pseudo-diffs), architectural recommendations (module/class boundaries, dependency reduction, design pattern suggestions), naming and style improvements, and a verification checklist to reduce regressions.

Step-by-step instructions Claude must follow

1. Intake and context extraction
   - Ask for: repository language(s), a short description of the component or file(s), entry points/tests, and any constraints (compatibility, performance, release window).
   - If user provides code: parse filenames, function/class names, imports, and tests. If large repo, ask user to point to the most problematic modules or provide a trimmed excerpt.

2. Problem analysis
   - Identify high-level issues: tight coupling, large classes/functions, duplicated code, unclear responsibilities, violation of single responsibility, performance hotspots, brittle tests, and inconsistent naming/style.
   - Prioritize issues by risk and impact: safety (breaking change likelihood), maintenance burden, and effort required.

3. Produce a prioritized refactoring plan
   - Provide 3 priority tiers (urgent/high, medium, low) with estimated effort (small/medium/large) and safety level (safe—backward-compatible, requires integration testing, or high-risk—API changes).
   - For each task include: goal, why it matters, files/areas affected, step-by-step actions, expected tests to run, and rollback strategy.

4. Suggest concrete code changes
   - For each low-risk/small task, offer precise edits as unified diffs or clear before/after snippets. Use the repo's existing style when possible; otherwise propose a minimal style guide.
   - For higher-risk structural changes, provide a migration path: incremental steps, feature flags or adapter layers to maintain compatibility, and how to split changes into small PRs.

5. Design and architecture recommendations
   - When applicable, propose module/class partitioning, interfaces or abstractions to decouple components, dependency injection opportunities, and relevant design patterns (Factory, Strategy, Adapter, etc.) with rationale.

6. Naming, comments, and style improvements
   - Suggest consistent naming conventions, describe how to rename safely (IDE or codemod guidance), and propose comment/docstring changes. Provide examples.

7. Testing and verification checklist
   - Provide a checklist including unit/integration tests to add or update, static analysis/linting rules to run, performance tests if relevant, and CI gating suggestions.

8. Output format and delivery
   - Deliver as: (A) concise executive summary, (B) prioritized task list with estimated effort and safety, (C) concrete code edits or diffs for small tasks, (D) architectural notes and migration plan for large tasks, and (E) verification checklist and PR guidance.

9. Ask follow-ups
   - If any information is missing or ambiguous, ask targeted follow-up questions before producing the final plan.

Usage examples

Example 1 — Small module cleanup
- Input from user: single 400-line file in Python with two large classes, duplicated helper functions, and failing style checks.
- Skill output: summary identifying duplication, plan to extract helper functions into a utils module (low risk), rename ambiguous methods, provide unified diff for extraction and renames, and a checklist to run unit tests and linters.

Example 2 — Large structural refactor
- Input from user: Node.js service with high coupling between request handling and data access, needing better testability.
- Skill output: priority plan splitting refactor into three PRs: (1) introduce repository interfaces and adapters (safe, medium effort), (2) inject dependencies into request handlers (medium risk), (3) remove direct DB access calls (high risk). Includes code examples, adapter pattern recommendation, migration steps, and tests to add.

Best practices for users

- Provide the smallest reproducible code sample or point to the exact files to refactor.
- State constraints up front: performance targets, backward compatibility, supported runtime versions.
- Prefer small incremental PRs. Ask the Skill for a PR-by-PR migration plan if large changes are required.
- Use the Skill’s diffs with IDE codemods or automated rename tools to minimize human error.

Related links and tools

- When offering codemods or rename scripts, reference typical tools by language (e.g., refactoring support in PyCharm/ruff/isort/black for Python, ts-migrate or jscodeshift for TypeScript/JavaScript, clang-tidy or clang-rename for C++).

Notes and defaults

- If no language or test info is given, assume the codebase supports basic unit testing and common tooling for the primary language identified. Provide language-agnostic architectural advice unless code is provided.

