---
name: code-review-skill
description: 버그 탐지, 정확성 검사, 스타일 및 가독성 개선, 실행 가능한 단계별 수정 등을 위해 철저한 코드 리뷰를 수행하는 능력. 트리거: "이 코드 검토", "코드 리뷰", "버그 찾기", "가독성 개선", "코드 감사".
---
# Code Review Skill

Purpose

This Skill guides Claude to perform a structured, developer-focused code review. It detects bugs and logical errors, checks correctness, evaluates style and readability, and produces a concise summary plus file-by-file detailed comments with stepwise fixes and examples. It is intended for use by engineering teams who want fast, high-quality peer-review feedback.

Step-by-step instructions (follow exactly)

1. Intake
   - Ask for or accept: repository/file context, programming language, target runtime/environment, relevant tests or failing inputs, and any specific review focus (bugs, performance, security, style).
   - If missing, request the smallest reproducible code snippet, instructions to run, and sample inputs/expected outputs.

2. High-level analysis
   - Identify the primary purpose of the code and expected behavior.
   - Note the language, frameworks, and any version constraints.

3. Automated checks (static reasoning)
   - Look for common bug patterns: off-by-one, null/None checks, race conditions, unchecked errors/exceptions, incorrect boundary handling, misuse of APIs, insecure patterns (e.g., SQL injection, unsafe eval), and resource leaks.
   - Verify algorithmic correctness for critical logic paths; reason through edge cases and invariants.
   - Check for performance anti-patterns (N+1 queries, excessive allocations, expensive loops) when relevant.

4. Style and readability
   - Evaluate naming, function/method length, comment usefulness, and adherence to common style guides for the language (PEP8 for Python, Google style for JS/Java, etc.).
   - Suggest refactors to improve clarity (extract function, reduce nesting, use guard clauses, simplify conditionals).

5. Tests and reproducibility
   - Recommend missing unit/integration tests or improvements to existing tests.
   - Suggest minimal example inputs to reproduce reported issues.

6. Output structure
   - Produce a brief Summary (3–6 bullet points) that lists major findings: critical bugs, correctness issues, security risks, or major style problems.
   - Then produce Detailed File-by-File Comments. For each file or snippet:
     a. Location/context header (filename, function/class, line range if provided).
     b. Severity tag: Critical / Important / Minor / Suggestion.
     c. Explanation of the issue and why it matters (concise).
     d. Repro steps or failing example if applicable.
     e. Step-by-step fix instructions (ordered, actionable). If code edits are needed, provide suggested patch or precise diff-like snippet.
     f. Positive notes: what is done well in this file/function.

7. Prioritization and checklist
   - End with a short prioritized checklist (high → low) for the author: must-fix, should-fix, nice-to-have.

8. Tone and delivery
   - Be constructive, respectful, and educational. Explain reasoning and trade-offs. Avoid being prescriptive when multiple valid options exist—present pros/cons.

9. When uncertain
   - If the reviewer cannot determine correctness due to missing tests/environment, explicitly list assumptions and request more info or test cases.

Usage examples

Example 1 (small snippet)
- Input prompt: "Review this Python function that reverses a linked list (paste function). Focus on correctness and edge cases."
- Expected output: Summary of issues (e.g., fails on empty list, tail pointer not cleared), then file-level comment with line-by-line notes and a corrected function snippet and test cases.

Example 2 (multi-file repo)
- Input prompt: "Review the attached repo for concurrency bugs and performance issues. Provide summary + file-by-file comments."
- Expected output: High-level summary with concurrency risks flagged, then for each file: locations, severity, stepwise fixes (locking strategies, atomic ops), and suggested benchmarks or tests.

Best practices

- Always begin with clarifying questions if environment, inputs, or intended behavior are unclear.
- Keep summaries short and prioritized; reserve details for the file-level section.
- Provide minimal reproducible examples and unit tests where feasible.
- When suggesting code changes, include small, focused diffs or full replacement snippets for copy-paste.
- Use severity labels to help triage.

Related links / placeholders

- If a repository is provided, reference file paths and line numbers precisely in comments.
- Optionally include sample test commands (e.g., pytest tests/test_xyz.py) when recommending tests.

Notes / Defaults

- Default to common language style guides if the project does not specify one.
- If no specific focus is requested, run correctness, bug detection, security, and style checks in that order.
