---
name: frontend-button-test-runner
description: Generates Playwright/Jest-style button interaction tests for frontend UIs, runs them, shows a concise pass/fail summary (pass/fail + failed case names), and writes execution logs.
---
Skill purpose

This Skill helps QA engineers automatically create tests for frontend UI buttons (click behavior such as navigation, modal open, API calls), execute those tests immediately, present a brief execution summary (overall pass/fail plus failed test names), and save structured logs for later inspection.

Step-by-step instructions Claude must follow

1. Collect inputs from the user:
   - Base URL or local dev URL to test.
   - A list of buttons to test. For each button: a CSS selector (or XPath), an expected behavior type (navigation, modal, API call, state change), and expected result details (target URL fragment, modal selector visible, API endpoint called, element text change, etc.).
   - Preferred test framework: default to Playwright with Jest test runner.
   - Optional: run-headless flag and log directory path (default: ./test-logs).

2. Validate inputs and normalize them into a structured JSON test plan. If any required information is missing, ask concise clarifying questions.

3. Generate a test file from the normalized test plan using a Playwright/Jest template. The generated test should:
   - Launch a browser context (headless by default, configurable).
   - Navigate to the provided base URL.
   - For each button test: locate the selector, click it, wait for the expected condition (navigation URL, visible modal selector, network request matched, DOM change), and assert the expected result.
   - Use timeouts and retries for flakiness mitigation (configurable defaults).
   - Emit console logs for each step (start test, click, wait result, assertion pass/fail).

4. Create a runner script that executes the generated tests and captures output and structured logs.
   - Run the test (npx playwright test or node with Jest configuration) and capture stdout/stderr.
   - Produce a concise summary: total tests, passed, failed. List failed test names.
   - Save detailed logs (raw stdout, per-test JSON result) under the configured log directory with a timestamped filename.

5. Execute the runner script if the user requested immediate execution.

6. Parse test results and present to the user a short summary message:
   - Overall status (PASS if all tests passed, FAIL otherwise).
   - Total tests run, number passed, number failed.
   - If failed: list failed test case names (only names) and provide the path to the detailed log file.

7. Offer next actions: re-run tests (with different flags), modify test plan, or export test files.

Usage examples

1) Generate tests then run immediately
- User provides base URL: http://localhost:3000
- Buttons list:
  - { selector: '#submitBtn', type: navigation, expected: '/thank-you' }
  - { selector: '.open-modal', type: modal, expectedSelector: '#signupModal' }
- Claude generates tests/playwright-button.test.ts and a runner script, executes them, and returns:
  - PASS/FAIL summary (e.g., "FAIL — 2 run, 1 failed: opens modal")
  - Link to log file: ./test-logs/2026-01-26T15-04-02.log.json

2) Generate tests only
- User asks to generate tests without running.
- Claude outputs the generated test file and runner script, and instructions to run locally: e.g., `npm install playwright jest && npx playwright test`.

Best practices

- Prefer CSS selectors that are resilient (data-test-id or data-testid attributes) rather than deeply nested class selectors.
- Limit per-test assertions to one primary expectation to keep failures clear (e.g., navigation occurred OR modal visible).
- Use realistic test data and ensure the test environment (mocked API or dedicated test backend) is stable.
- Keep headless as default for CI; allow headful for local debugging.
- Store logs in a centralized location (./test-logs) and include timestamps in filenames for traceability.

Related files

- templates/playwright-button.test.ts — Playwright/Jest test template generated from the test plan.
- scripts/run-playwright-tests.sh — Runner script that executes tests, captures output, writes JSON logs, and prints the concise summary.

When to ask follow-up questions

- If selectors are missing or ambiguous.
- If expected behavior details are incomplete (e.g., navigation expected URL not provided).
- If user requests a framework other than Playwright/Jest.

Notes and defaults

- Default framework: Playwright with Jest-like assertions.
- Default headless mode: true.
- Default log directory: ./test-logs.
- Default timeout per action: 5000 ms (configurable).
