---
name: photo-to-layout-css-updater
description: Converts a provided reference photo into updated HTML/CSS (responsive desktop + mobile) that re-styles and re-structures an existing web template to match the photo while preserving original HTML structure and JavaScript behavior. Triggers: upload reference image + existing HTML file or paste HTML, request responsive CSS updates, ask to keep JS intact.
---

Skill purpose

This Skill takes a reference photo (screenshot of a target web layout) and an existing web template (HTML file or pasted HTML). It produces complete, ready-to-paste HTML and CSS (or a CSS file and minimal HTML modifications) that make the page visually match the photo across desktop and mobile breakpoints. The original HTML structure and JavaScript behavior are preserved; only layout and style (positioning, colors, fonts, spacing, responsive rules) are changed unless minimal structural changes are necessary and explicitly requested.

Step-by-step instructions (strict steps Claude must follow)

1. Input validation
   - Confirm receipt of: (a) a reference photo (URL or uploaded image), and (b) the original HTML (file or pasted code). Ask clarifying questions if anything is missing (e.g., project fonts, color preferences, assets).

2. Visual analysis of the reference photo
   - Identify layout regions: header, hero, nav, sidebars, content sections, cards, footer, grids, images, buttons, forms.
   - Identify visual properties per region: spacing, alignment, column counts, stacking order, typography (size, weight), primary/secondary colors, background styles, border/radius, and notable interactions (hover, sticky header, overlays).
   - Note responsive differences visible in the photo (desktop vs mobile) or ask user for intended breakpoints if unclear.

3. Map photo elements to the existing HTML
   - Parse the provided HTML and build a mapping from photo-identified regions to existing elements (by id/class/tag). When ambiguous, propose mappings and ask user to confirm.
   - Do not modify JS files or inline scripts. If an element must receive an id/class for styling, prefer adding classes and document the change. Avoid changing element semantics unless necessary; request permission before structural changes.

4. Generate CSS and minimal HTML adjustments
   - Produce a complete CSS stylesheet (or CSS + small HTML snippets only if necessary) that can be dropped into the project. The stylesheet must be self-contained, using sensible names scoped to existing classes if possible, or using a short unique wrapper class to avoid collisions (e.g., .ptlu-namespace { } ).
   - Include responsive rules: at minimum a desktop layout and a mobile layout (mobile-first or desktop-first as requested). Use common breakpoints (e.g., 1024px, 768px) and make them configurable in comments.
   - Use modern CSS (Flexbox and CSS Grid) for layout and use CSS variables for primary colors and fonts so the user can tweak easily.
   - Keep CSS specificity moderate; prefer classes over id selectors. Avoid !important unless absolutely required; if used, document the reason.
   - If small, non-breaking HTML changes are required (e.g., adding wrapper divs or adding classes), produce an exact HTML snippet showing only the changed lines and clearly mark insertion points. Explain why each change is necessary.

5. Produce final deliverables
   - Provide: (a) the full CSS file contents, and (b) either the original HTML annotated with where to include the stylesheet and any small changes, or a single combined HTML file (complete and ready to paste) if the user prefers.
   - Ensure the HTML references the stylesheet (link tag in head) and preserves original script tags and behavior.
   - Include clear instructions for where to paste files and how to test (e.g., open in browser, recommended viewport sizes).

6. Notes, assumptions, and testing guidance
   - List assumptions made about fonts, missing assets, or ambiguous regions.
   - If fonts or images from the photo are proprietary or missing, offer nearest free alternatives and include font import snippets (Google Fonts) if used.
   - Provide a minimal testing checklist (desktop and mobile viewport sizes to test, interactions to verify).

7. Iteration and feedback loop
   - Ask the user to confirm visual fidelity and request any refinements. Offer follow-up steps: adjust spacing, tweak colors, add animations, or produce CSS variables for theme support.

Usage examples

Example 1 — User supplies HTML + photo URL
- User: "Here is my index.html (pasted) and this reference screenshot: https://example.com/target.png. Update the layout and styles to match, keep my JS intact. Provide responsive CSS and a single combined HTML file I can paste into my project."
- Claude (using this Skill):
  1) Confirms receipt and any missing details.
  2) Analyzes the screenshot and maps header, hero, card grid, and footer to elements in index.html.
  3) Produces a ready-to-paste index.html that links to style-photo.css and includes a small added wrapper class and two extra classes on specific elements. The original <script> tags remain unchanged.
  4) Provides style-photo.css with variables for --primary-color and --base-font, CSS Grid for the card layout, and media queries at 1024px and 600px.
  5) Includes an assumptions block (font chosen: Inter), and testing checklist.

Example 2 — Minimal inline update request
- User: "I only want CSS — don’t change HTML. Photo attached. Make it responsive."
- Claude: Generates a stylesheet that targets existing classes (or suggests adding a single wrapper id if specificity issues arise) and provides the CSS only, with comments on where to include it.

Best Practices

- Preserve behavior: Never modify or remove existing script tags or inline JavaScript unless the user explicitly asks.
- Prefer additive changes: Add classes or wrapper elements rather than changing element types or major DOM restructuring. Explain any structural edits clearly.
- Scoped styling: Use a short namespace class or CSS variables to prevent collisions with existing site styles.
- Mobile-first: Build responsive rules with mobile-first methodology unless user requests otherwise.
- Accessibility: Maintain semantic HTML, ensure color contrast is reasonable, and retain focus outlines unless a11y-friendly replacements are provided.
- Small increments: Provide incremental CSS changes with short diff-like snippets when possible to help developers apply updates safely.

Prompt templates to use when interacting with the user

- Initial request (when user supplies files): "Please upload the reference screenshot and paste the existing HTML (or attach the HTML file). Specify any font or color preferences, and confirm whether I may add classes or small wrapper elements if needed." 

- Clarifying question examples:
  - "I see two possible header elements in your HTML. Should the large top bar in the photo map to .main-header or .site-top?"
  - "The photo uses a custom font I don't have. Do you want me to pick a similar Google Font (recommended) or keep your current font?"

When to ask follow-up questions

- If mapping photo regions to HTML elements is ambiguous.
- If fonts, brand colors, or images are missing or proprietary.
- If required structural changes exceed adding classes/wrappers.

Related files and references

- The delivered output may include:
  - style-photo.css (complete stylesheet)
  - index-photo.html (combined HTML ready to paste) — only if user requests a single file output

supporting_files: []
