---
name: 개발 브랜치에 푸시하기
description: 현재 피쳐브랜치(feat/*, bug/*, hotfix/*...) 커밋내용을 develop 브랜치에 merge하고 push 하는 스킬
---
# 개발 브랜치에 푸시하기

## 워크 플로우
1. 현재 브랜치 확인 (feature/*, feat/*, bug/*, hotfix/* 중 하나여야 함)
current_branch=$(git branch --show-current)

2. develop 브랜치로 이동 및 최신화
git checkout develop
git pull origin develop

3. 피쳐 브랜치 머지 (merge commit)
git merge --no-ff $current_branch

4. 충돌 발생 시 → 작업 중단, 사용자에게 알림
충돌 없으면 → push
git push origin develop


## 충돌 발생 시
머지 충돌이 발생하면:

1. 즉시 작업 중단
2. git merge --abort로 머지 취소
3. 맥 알림으로 충돌 발생 알림

```
# 프로젝트명, 브랜치명 추출
project_name=$(basename $(git rev-parse --show-toplevel))
current_branch=$(git branch --show-current)

# 맥 알림 발송
osascript -e "display notification \"[$project_name] $current_branch 머지 중 충돌 발생. 수동으로 해결해주세요.\" with title \"Git 머지 충돌 발생\" sound name \"Basso\""
```

## 주의사항

develop 브랜치 최신화(git pull) 필수
develop 브랜치의 uncommitted 변경사항은 자동으로 drop됨
피쳐 브랜치의 작업 내용은 머지 전 커밋되어 있어야 함
리모트 origin이 설정되어 있어야 함
