---
name: readme-landingpage-generator
description: Generates a polished README landing-page-style Markdown file for a codebase aimed at non-developer end users. Triggers: "generate README", "create landing README", "make user-friendly README".
---

# Skill purpose

Produce a single README.md (Markdown) that reads like a product landing page for a repository. The README targets general users (non-developers) and includes: motivation, program introduction, very detailed features, step-by-step usage (installation, basic use, settings) with screenshots/GIF recommendations, and developer info. Tone: inclusive and beginner-friendly with clear steps, short examples, and a small FAQ/troubleshooting section.

# Step-by-step instructions Claude must follow

1. Repository scan
   - Read project files: package manifests (package.json, pyproject.toml, setup.py), README(s), docs/, src/ or main/ directories, Dockerfile, .github, and any CONTRIBUTING or CHANGELOG files.
   - Determine primary language(s), runtime, and whether this is an app, library, CLI, web app, or service.
   - Gather name, description, version, license, repository URL, author(s)/maintainers from metadata files.

2. Identify user-focused features
   - Inspect code and docs to enumerate every user-visible feature. For ambiguous items, infer feature from top-level modules, CLI commands, routes, UI labels, or config keys.
   - For each feature, produce a short summary (1–2 lines) and a detailed explanation (3–6 lines) with example user scenarios (what it does, when to use it, expected outcome).

3. Create installation instructions (beginner-friendly)
   - Detect installation paths: packaged install (pip/npm), binary releases, Docker, or manual steps.
   - Provide step-by-step commands for the simplest path first, then alternatives. Include troubleshooting tips for common issues (permissions, ports, missing dependencies).

4. Create basic usage guide (very detailed)
   - Provide an annotated quick-start showing the minimal commands or click sequences to accomplish the most common task(s). Use placeholders for repository-specific commands if exact commands are not determinable (mark as "Replace <...>").
   - Suggest sample inputs and show expected outputs or screenshots.
   - For GUIs, propose where to capture 1–2 screenshots and recommend a short GIF for the core flow. Provide suggested alt text and filenames.

5. Advanced configuration and settings
   - List configuration options and where to change them (config files, env vars, UI settings). For each option give default values, valid ranges/formats, and examples.

6. Developer & contribution section
   - Include a short developer contact/maintainer block from repo metadata, contribution guidelines and links to source/issue tracker. If no guidelines exist, add a brief template: how to file an issue, how to submit a PR, code style note.

7. Add FAQ / Troubleshooting
   - Generate 6–8 likely Q&A entries for non-developers (installation failures, login issues, update steps, data backup, where to find logs). Keep answers concise and actionable.

8. Compose README structure and formatting
   - Produce a landing-page style README.md with: Hero section (name, short tagline, 1–2 sentence value proposition), Why we built it, Features (detailed), Quick Start (installation + one-min demo), Detailed Usage, Configuration, Screenshots/GIF placeholders, FAQ/Troubleshooting, Developer/Contact, License & Credits.
   - Use short headings, bullet lists, numbered steps, code blocks for commands, and emphasized callouts for important notes.
   - Ensure readability for non-developers: avoid jargon, explain necessary technical terms in simple language.

9. Output
   - Return a single Markdown string (README.md content). Include image placeholders as relative paths (e.g., assets/screenshot-1.png, assets/demo.gif) with recommended captions and alt text.
   - If any steps used placeholders (commands or filenames), clearly mark them with <angle-brackets> and include instructions to replace.

# Usage examples

Example 1 — CLI app
- User prompt: "Generate README for this repo (CLI todo app)."
- Actions Claude performs: scans package.json, finds bin script "todo", extracts commands (add, list, done), creates a landing README with one-line install (npm i -g <pkg>), quick demo (todo add "Buy milk"), screenshots placeholders, and FAQ about data location.

Example 2 — Web app
- User prompt: "Create user README for web dashboard repo."
- Actions: detect Dockerfile + requirements, provide Docker quick-start, browser access URL steps, core features described (login, reports, export), suggest where to record a GIF for the main report generation flow.

Example 3 — Desktop app
- User prompt: "Make README for Electron app repository."
- Actions: detect electron build targets, list download/install options for Windows/Mac/Linux, give quick-start with screenshots of main window and preference panel, and troubleshooting notes for gatekeeper/antivirus prompts.

# Best practices

- Prioritize the simplest install/run path and label alternatives clearly.
- Use screenshots/GIFs judiciously: 1–2 screenshots and one short GIF for the core flow. Suggest resolution ~1280×720 and under 5–10s for GIFs.
- Keep language non-technical; where technical terms are necessary, provide a one-line plain-language definition.
- Mark any placeholder values clearly with <angle-brackets> and include a short "How to replace placeholders" note near the top of the README.
- If uncertain about a feature or command, include a short "Notes/Assumptions" block explaining what was inferred and how to correct it.

# Templates and example snippets (to include when generating README)

- Hero header example:
  - ProjectName — Short tagline
  - One-liner value prop

- Quick install block example:
  - curl -sL <download-url> | bash
  - or npm i -g <package-name>

- Screenshot placeholder Markdown:
  - ![Main screen](assets/screenshot-1.png "Main application screen")

- GIF placeholder Markdown:
  - ![Demo GIF](assets/demo.gif "Quick demo of core feature")

# When to ask follow-up questions

If any of the following cannot be inferred automatically, ask the user a short follow-up question before generating the README:
- Project display name or preferred tagline
- Primary target platform (web, desktop, mobile, CLI)
- Preferred simplest install method (package manager, Docker, binary)
- Whether screenshots/GIFs are available or must be created

# Output format requirement

Return exactly one file: README.md content as Markdown text. Use relative image paths for media and include clear placeholder names for assets that the user must add.
